/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cache;

import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.common.annotations.GwtCompatible;
import org.elasticsearch.common.base.Supplier;
import org.elasticsearch.common.cache.LongAddable;
import org.elasticsearch.common.cache.LongAdder;

@GwtCompatible(emulated=true)
final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            new LongAdder();
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t) {
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x2) {
            this.getAndAdd(x2);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

