/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;

public class BlobStores {
    public static void syncWriteBlob(ImmutableBlobContainer blobContainer, String blobName, InputStream is, long sizeInBytes2) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference failure2 = new AtomicReference();
        blobContainer.writeBlob(blobName, is, sizeInBytes2, new ImmutableBlobContainer.WriterListener(){

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failure2.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting to write [" + blobName + "]");
        }
        if (failure2.get() != null) {
            if (failure2.get() instanceof IOException) {
                throw (IOException)failure2.get();
            }
            throw new IOException("Failed to get [" + blobName + "]", (Throwable)failure2.get());
        }
    }
}

