/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.collect.ImmutableMap;

public abstract class AbstractBlobContainer
implements BlobContainer {
    private final BlobPath path;

    protected AbstractBlobContainer(BlobPath path) {
        this.path = path;
    }

    @Override
    public BlobPath path() {
        return this.path;
    }

    @Override
    public byte[] readBlobFully(String blobName) throws IOException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference failure2 = new AtomicReference();
        final ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.readBlob(blobName, new BlobContainer.ReadBlobListener(){

            @Override
            public void onPartial(byte[] data2, int offset, int size2) {
                bos.write(data2, offset, size2);
            }

            @Override
            public void onCompleted() {
                latch.countDown();
            }

            @Override
            public void onFailure(Throwable t) {
                failure2.set(t);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while waiting to read [" + blobName + "]");
        }
        if (failure2.get() != null) {
            if (failure2.get() instanceof IOException) {
                throw (IOException)failure2.get();
            }
            throw new IOException("Failed to get [" + blobName + "]", (Throwable)failure2.get());
        }
        return bos.toByteArray();
    }

    @Override
    public ImmutableMap<String, BlobMetaData> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        ImmutableMap<String, BlobMetaData> allBlobs = this.listBlobs();
        ImmutableMap.Builder<String, BlobMetaData> blobs = ImmutableMap.builder();
        for (BlobMetaData blob : allBlobs.values()) {
            if (!blob.name().startsWith(blobNamePrefix)) continue;
            blobs.put(blob.name(), blob);
        }
        return blobs.build();
    }

    @Override
    public void deleteBlobsByPrefix(final String blobNamePrefix) throws IOException {
        this.deleteBlobsByFilter(new BlobContainer.BlobNameFilter(){

            @Override
            public boolean accept(String blobName) {
                return blobName.startsWith(blobNamePrefix);
            }
        });
    }

    @Override
    public void deleteBlobsByFilter(BlobContainer.BlobNameFilter filter2) throws IOException {
        ImmutableMap<String, BlobMetaData> blobs = this.listBlobs();
        for (BlobMetaData blob : blobs.values()) {
            if (!filter2.accept(blob.name())) continue;
            this.deleteBlob(blob.name());
        }
    }
}

