/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore.fs;

import java.io.File;
import java.util.concurrent.Executor;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.BlobStoreException;
import org.elasticsearch.common.blobstore.ImmutableBlobContainer;
import org.elasticsearch.common.blobstore.fs.FsImmutableBlobContainer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class FsBlobStore
extends AbstractComponent
implements BlobStore {
    private final Executor executor;
    private final File path;
    private final int bufferSizeInBytes;

    public FsBlobStore(Settings settings, Executor executor, File path) {
        super(settings);
        boolean b;
        this.path = path;
        if (!path.exists() && !(b = FileSystemUtils.mkdirs(path))) {
            throw new BlobStoreException("Failed to create directory at [" + path + "]");
        }
        if (!path.isDirectory()) {
            throw new BlobStoreException("Path is not a directory at [" + path + "]");
        }
        this.bufferSizeInBytes = (int)settings.getAsBytesSize("buffer_size", new ByteSizeValue(100L, ByteSizeUnit.KB)).bytes();
        this.executor = executor;
    }

    public String toString() {
        return this.path.toString();
    }

    public File path() {
        return this.path;
    }

    public int bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public Executor executor() {
        return this.executor;
    }

    @Override
    public ImmutableBlobContainer immutableBlobContainer(BlobPath path) {
        return new FsImmutableBlobContainer(this, path, this.buildAndCreate(path));
    }

    @Override
    public void delete(BlobPath path) {
        FileSystemUtils.deleteRecursively(this.buildPath(path));
    }

    @Override
    public void close() {
    }

    private synchronized File buildAndCreate(BlobPath path) {
        File f2 = this.buildPath(path);
        FileSystemUtils.mkdirs(f2);
        return f2;
    }

    private File buildPath(BlobPath path) {
        String[] paths = path.toArray();
        if (paths.length == 0) {
            return this.path();
        }
        File blobPath = new File(this.path, paths[0]);
        if (paths.length > 1) {
            for (int i = 1; i < paths.length; ++i) {
                blobPath = new File(blobPath, paths[i]);
            }
        }
        return blobPath;
    }
}

