/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.Collection;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.ElasticSearchNullPointerException;

public final class Preconditions {
    private Preconditions() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public static void checkArgument(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new ElasticSearchIllegalArgumentException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException();
        }
    }

    public static void checkState(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException(String.valueOf(errorMessage));
        }
    }

    public static void checkState(boolean expression, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new ElasticSearchIllegalStateException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T checkNotNull(T reference) {
        if (reference == null) {
            throw new ElasticSearchNullPointerException();
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, Object errorMessage) {
        if (reference == null) {
            throw new ElasticSearchNullPointerException(String.valueOf(errorMessage));
        }
        return reference;
    }

    public static <T> T checkNotNull(T reference, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (reference == null) {
            throw new ElasticSearchNullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return reference;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException();
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, Object errorMessage) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException(String.valueOf(errorMessage));
        }
        return iterable;
    }

    public static <T extends Iterable<?>> T checkContentsNotNull(T iterable, String errorMessageTemplate, Object ... errorMessageArgs) {
        if (Preconditions.containsOrIsNull(iterable)) {
            throw new ElasticSearchNullPointerException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
        return iterable;
    }

    private static boolean containsOrIsNull(Iterable<?> iterable) {
        if (iterable == null) {
            return true;
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            try {
                return collection.contains(null);
            }
            catch (ElasticSearchNullPointerException e) {
                return false;
            }
        }
        for (Object element : iterable) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    public static void checkElementIndex(int index, int size2) {
        Preconditions.checkElementIndex(index, size2, "index");
    }

    public static void checkElementIndex(int index, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index));
        }
        if (index >= size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must be less than size (%s)", desc, index, size2));
        }
    }

    public static void checkPositionIndex(int index, int size2) {
        Preconditions.checkPositionIndex(index, size2, "index");
    }

    public static void checkPositionIndex(int index, int size2, String desc) {
        Preconditions.checkArgument(size2 >= 0, "negative size: %s", size2);
        if (index < 0) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be negative", desc, index));
        }
        if (index > size2) {
            throw new IndexOutOfBoundsException(Preconditions.format("%s (%s) must not be greater than size (%s)", desc, index, size2));
        }
    }

    public static void checkPositionIndexes(int start, int end, int size2) {
        Preconditions.checkPositionIndex(start, size2, "start index");
        Preconditions.checkPositionIndex(end, size2, "end index");
        if (end < start) {
            throw new IndexOutOfBoundsException(Preconditions.format("end index (%s) must not be less than start index (%s)", end, start));
        }
    }

    static String format(String template, Object ... args) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

