/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

public class Booleans {
    public static boolean parseBoolean(char[] text2, int offset, int length, boolean defaultValue) {
        if (text2 == null || length == 0) {
            return defaultValue;
        }
        if (length == 1) {
            return text2[offset] != '0';
        }
        if (length == 2) {
            return text2[offset] != 'n' || text2[offset + 1] != 'o';
        }
        if (length == 3) {
            return text2[offset] != 'o' || text2[offset + 1] != 'f' || text2[offset + 2] != 'f';
        }
        if (length == 5) {
            return text2[offset] != 'f' || text2[offset + 1] != 'a' || text2[offset + 2] != 'l' || text2[offset + 3] != 's' || text2[offset + 4] != 'e';
        }
        return true;
    }

    public static boolean isBoolean(char[] text2, int offset, int length) {
        if (text2 == null || length == 0) {
            return false;
        }
        if (length == 1) {
            return text2[offset] == '0' || text2[offset] == '1';
        }
        if (length == 2) {
            return text2[offset] == 'n' && text2[offset + 1] == 'o' || text2[offset] == 'o' && text2[offset + 1] == 'n';
        }
        if (length == 3) {
            return text2[offset] == 'o' && text2[offset + 1] == 'f' && text2[offset + 2] == 'f' || text2[offset] == 'y' && text2[offset + 1] == 'e' && text2[offset + 2] == 's';
        }
        if (length == 4) {
            return text2[offset] == 't' && text2[offset + 1] == 'r' && text2[offset + 2] == 'u' && text2[offset + 3] == 'e';
        }
        if (length == 5) {
            return text2[offset] == 'f' && text2[offset + 1] == 'a' && text2[offset + 2] == 'l' && text2[offset + 3] == 's' && text2[offset + 4] == 'e';
        }
        return false;
    }

    public static boolean parseBoolean(String value2, boolean defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        return !value2.equals("false") && !value2.equals("0") && !value2.equals("off") && !value2.equals("no");
    }

    public static Boolean parseBoolean(String value2, Boolean defaultValue) {
        if (value2 == null) {
            return defaultValue;
        }
        return !value2.equals("false") && !value2.equals("0") && !value2.equals("off") && !value2.equals("no");
    }

    public static boolean isExplicitFalse(String value2) {
        return value2.equals("false") || value2.equals("0") || value2.equals("off") || value2.equals("no");
    }

    public static boolean isExplicitTrue(String value2) {
        return value2.equals("true") || value2.equals("1") || value2.equals("on") || value2.equals("yes");
    }
}

