/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;

public interface Validator {
    public static final Validator EMPTY = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            return null;
        }
    };
    public static final Validator TIME = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (TimeValue.parseTimeValue(value2, null) == null) {
                    return "cannot parse value [" + value2 + "] as time";
                }
            }
            catch (ElasticSearchParseException ex) {
                return "cannot parse value [" + value2 + "] as time";
            }
            return null;
        }
    };
    public static final Validator FLOAT = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                Float.parseFloat(value2);
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as a float";
            }
            return null;
        }
    };
    public static final Validator NON_NEGATIVE_FLOAT = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if ((double)Float.parseFloat(value2) < 0.0) {
                    return "the value of the setting " + setting + " must be a non negative float";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as a double";
            }
            return null;
        }
    };
    public static final Validator DOUBLE = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                Double.parseDouble(value2);
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as a double";
            }
            return null;
        }
    };
    public static final Validator NON_NEGATIVE_DOUBLE = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (Double.parseDouble(value2) < 0.0) {
                    return "the value of the setting " + setting + " must be a non negative double";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as a double";
            }
            return null;
        }
    };
    public static final Validator DOUBLE_GTE_2 = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (Double.parseDouble(value2) < 2.0) {
                    return "the value of the setting " + setting + " must be >= 2.0";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as a double";
            }
            return null;
        }
    };
    public static final Validator INTEGER = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                Integer.parseInt(value2);
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as an integer";
            }
            return null;
        }
    };
    public static final Validator POSITIVE_INTEGER = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (Integer.parseInt(value2) <= 0) {
                    return "the value of the setting " + setting + " must be a positive integer";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as an integer";
            }
            return null;
        }
    };
    public static final Validator NON_NEGATIVE_INTEGER = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (Integer.parseInt(value2) < 0) {
                    return "the value of the setting " + setting + " must be a non negative integer";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as an integer";
            }
            return null;
        }
    };
    public static final Validator INTEGER_GTE_2 = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                if (Integer.parseInt(value2) < 2) {
                    return "the value of the setting " + setting + " must be >= 2";
                }
            }
            catch (NumberFormatException ex) {
                return "cannot parse value [" + value2 + "] as an integer";
            }
            return null;
        }
    };
    public static final Validator BYTES_SIZE = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            try {
                ByteSizeValue.parseBytesSizeValue(value2);
            }
            catch (ElasticSearchParseException ex) {
                return ex.getMessage();
            }
            return null;
        }
    };
    public static final Validator BOOLEAN = new Validator(){

        @Override
        public String validate(String setting, String value2) {
            if (value2 != null && (Booleans.isExplicitFalse(value2) || Booleans.isExplicitTrue(value2))) {
                return null;
            }
            return "cannot parse value [" + value2 + "] as a boolean";
        }
    };

    public String validate(String var1, String var2);
}

