/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class ShardsLimitAllocationDecider
extends AllocationDecider {
    public static final String INDEX_TOTAL_SHARDS_PER_NODE = "index.routing.allocation.total_shards_per_node";

    @Inject
    public ShardsLimitAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        int totalShardsPerNode = indexMd.settings().getAsInt(INDEX_TOTAL_SHARDS_PER_NODE, (Integer)-1);
        if (totalShardsPerNode <= 0) {
            return Decision.YES;
        }
        int nodeCount = 0;
        for (MutableShardRouting nodeShard : node) {
            if (!nodeShard.index().equals(shardRouting.index()) || nodeShard.relocating()) continue;
            ++nodeCount;
        }
        if (nodeCount >= totalShardsPerNode) {
            return Decision.NO;
        }
        return Decision.YES;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        int totalShardsPerNode = indexMd.settings().getAsInt(INDEX_TOTAL_SHARDS_PER_NODE, (Integer)-1);
        if (totalShardsPerNode <= 0) {
            return Decision.YES;
        }
        int nodeCount = 0;
        for (MutableShardRouting nodeShard : node) {
            if (!nodeShard.index().equals(shardRouting.index()) || nodeShard.relocating()) continue;
            ++nodeCount;
        }
        if (nodeCount > totalShardsPerNode) {
            return Decision.NO;
        }
        return Decision.YES;
    }
}

