/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class SameShardAllocationDecider
extends AllocationDecider {
    public static final String SAME_HOST_SETTING = "cluster.routing.allocation.same_shard.host";
    private final boolean sameHost;

    @Inject
    public SameShardAllocationDecider(Settings settings) {
        super(settings);
        this.sameHost = settings.getAsBoolean(SAME_HOST_SETTING, (Boolean)false);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        Iterable<MutableShardRouting> assignedShards = allocation.routingNodes().assignedShards(shardRouting);
        for (MutableShardRouting assignedShard : assignedShards) {
            if (!node.nodeId().equals(assignedShard.currentNodeId())) continue;
            return Decision.NO;
        }
        if (this.sameHost && node.node() != null) {
            for (RoutingNode checkNode : allocation.routingNodes()) {
                if (checkNode.node() == null || !checkNode.node().address().sameHost(node.node().address())) continue;
                for (MutableShardRouting assignedShard : assignedShards) {
                    if (!checkNode.nodeId().equals(assignedShard.currentNodeId())) continue;
                    return Decision.NO;
                }
            }
        }
        return Decision.YES;
    }
}

