/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    @Inject
    public NodeVersionAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        String sourceNodeId = shardRouting.currentNodeId();
        if (sourceNodeId == null) {
            if (shardRouting.primary()) {
                return Decision.YES;
            }
            MutableShardRouting primary = allocation.routingNodes().activePrimary(shardRouting);
            if (primary == null) {
                return Decision.YES;
            }
            sourceNodeId = primary.currentNodeId();
        }
        return this.isVersionCompatible(allocation.routingNodes(), sourceNodeId, node);
    }

    private Decision isVersionCompatible(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().version().onOrAfter(source.node().version())) {
            return Decision.YES;
        }
        return Decision.NO;
    }
}

