/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class FilterAllocationDecider
extends AllocationDecider {
    public static final String INDEX_ROUTING_REQUIRE_GROUP = "index.routing.allocation.require.";
    public static final String INDEX_ROUTING_INCLUDE_GROUP = "index.routing.allocation.include.";
    public static final String INDEX_ROUTING_EXCLUDE_GROUP = "index.routing.allocation.exclude.";
    public static final String CLUSTER_ROUTING_REQUIRE_GROUP = "cluster.routing.allocation.require.";
    public static final String CLUSTER_ROUTING_INCLUDE_GROUP = "cluster.routing.allocation.include.";
    public static final String CLUSTER_ROUTING_EXCLUDE_GROUP = "cluster.routing.allocation.exclude.";
    private volatile DiscoveryNodeFilters clusterRequireFilters;
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    @Inject
    public FilterAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        ImmutableMap<String, String> requireMap = settings.getByPrefix(CLUSTER_ROUTING_REQUIRE_GROUP).getAsMap();
        this.clusterRequireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
        ImmutableMap<String, String> includeMap = settings.getByPrefix(CLUSTER_ROUTING_INCLUDE_GROUP).getAsMap();
        this.clusterIncludeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
        ImmutableMap<String, String> excludeMap = settings.getByPrefix(CLUSTER_ROUTING_EXCLUDE_GROUP).getAsMap();
        this.clusterExcludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation) ? Decision.NO : Decision.YES;
    }

    @Override
    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation) ? Decision.NO : Decision.YES;
    }

    private boolean shouldFilter(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (this.clusterRequireFilters != null && !this.clusterRequireFilters.match(node.node())) {
            return true;
        }
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node.node())) {
            return true;
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node.node())) {
            return true;
        }
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        if (indexMd.requireFilters() != null && !indexMd.requireFilters().match(node.node())) {
            return true;
        }
        if (indexMd.includeFilters() != null && !indexMd.includeFilters().match(node.node())) {
            return true;
        }
        return indexMd.excludeFilters() != null && indexMd.excludeFilters().match(node.node());
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ImmutableMap<String, String> excludeMap;
            ImmutableMap<String, String> includeMap;
            ImmutableMap<String, String> requireMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_REQUIRE_GROUP).getAsMap();
            if (!requireMap.isEmpty()) {
                FilterAllocationDecider.this.clusterRequireFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
            }
            if (!(includeMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_INCLUDE_GROUP).getAsMap()).isEmpty()) {
                FilterAllocationDecider.this.clusterIncludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
            }
            if (!(excludeMap = settings.getByPrefix(FilterAllocationDecider.CLUSTER_ROUTING_EXCLUDE_GROUP).getAsMap()).isEmpty()) {
                FilterAllocationDecider.this.clusterExcludeFilters = DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
            }
        }
    }
}

