/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.shard.ShardId;

public class MoveAllocationCommand
implements AllocationCommand {
    public static final String NAME = "move";
    private final ShardId shardId;
    private final String fromNode;
    private final String toNode;

    public MoveAllocationCommand(ShardId shardId, String fromNode, String toNode) {
        this.shardId = shardId;
        this.fromNode = fromNode;
        this.toNode = toNode;
    }

    @Override
    public String name() {
        return NAME;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String fromNode() {
        return this.fromNode;
    }

    public String toNode() {
        return this.toNode;
    }

    @Override
    public void execute(RoutingAllocation allocation) throws ElasticSearchException {
        DiscoveryNode fromDiscoNode = allocation.nodes().resolveNode(this.fromNode);
        DiscoveryNode toDiscoNode = allocation.nodes().resolveNode(this.toNode);
        boolean found = false;
        for (MutableShardRouting shardRouting : allocation.routingNodes().node(fromDiscoNode.id())) {
            if (!shardRouting.shardId().equals(this.shardId)) continue;
            found = true;
            if (!shardRouting.started()) {
                throw new ElasticSearchIllegalArgumentException("[move_allocation] can't move " + this.shardId + ", shard is not started (state = " + (Object)((Object)shardRouting.state()) + "]");
            }
            RoutingNode toRoutingNode = allocation.routingNodes().node(toDiscoNode.id());
            Decision decision = allocation.deciders().canAllocate(shardRouting, toRoutingNode, allocation);
            if (decision.type() == Decision.Type.NO) {
                throw new ElasticSearchIllegalArgumentException("[move_allocation] can't move " + this.shardId + ", from " + fromDiscoNode + ", to " + toDiscoNode + ", since its not allowed, reason: " + decision);
            }
            if (decision.type() == Decision.Type.THROTTLE) {
                // empty if block
            }
            allocation.routingNodes().assign(new MutableShardRouting(shardRouting.index(), shardRouting.id(), toRoutingNode.nodeId(), shardRouting.currentNodeId(), shardRouting.primary(), ShardRoutingState.INITIALIZING, shardRouting.version() + 1L), toRoutingNode.nodeId());
            allocation.routingNodes().relocate(shardRouting, toRoutingNode.nodeId());
        }
        if (!found) {
            throw new ElasticSearchIllegalArgumentException("[move_allocation] can't move " + this.shardId + ", failed to find it on node " + fromDiscoNode);
        }
    }

    public static class Factory
    implements AllocationCommand.Factory<MoveAllocationCommand> {
        @Override
        public MoveAllocationCommand readFrom(StreamInput in) throws IOException {
            return new MoveAllocationCommand(ShardId.readShardId(in), in.readString(), in.readString());
        }

        @Override
        public void writeTo(MoveAllocationCommand command, StreamOutput out) throws IOException {
            command.shardId().writeTo(out);
            out.writeString(command.fromNode());
            out.writeString(command.toNode());
        }

        @Override
        public MoveAllocationCommand fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token2;
            String index = null;
            int shardId = -1;
            String fromNode = null;
            String toNode = null;
            String currentFieldName = null;
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2.isValue()) {
                    if ("index".equals(currentFieldName)) {
                        index = parser.text();
                        continue;
                    }
                    if ("shard".equals(currentFieldName)) {
                        shardId = parser.intValue();
                        continue;
                    }
                    if ("from_node".equals(currentFieldName) || "fromNode".equals(currentFieldName)) {
                        fromNode = parser.text();
                        continue;
                    }
                    if ("to_node".equals(currentFieldName) || "toNode".equals(currentFieldName)) {
                        toNode = parser.text();
                        continue;
                    }
                    throw new ElasticSearchParseException("[move] command does not support field [" + currentFieldName + "]");
                }
                throw new ElasticSearchParseException("[move] command does not support complex json tokens [" + (Object)((Object)token2) + "]");
            }
            if (index == null) {
                throw new ElasticSearchParseException("[move] command missing the index parameter");
            }
            if (shardId == -1) {
                throw new ElasticSearchParseException("[move] command missing the shard parameter");
            }
            if (fromNode == null) {
                throw new ElasticSearchParseException("[move] command missing the from_node parameter");
            }
            if (toNode == null) {
                throw new ElasticSearchParseException("[move] command missing the to_node parameter");
            }
            return new MoveAllocationCommand(new ShardId(index, shardId), fromNode, toNode);
        }

        @Override
        public void toXContent(MoveAllocationCommand command, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index", (Object)command.shardId().index());
            builder.field("shard", command.shardId().id());
            builder.field("from_node", command.fromNode());
            builder.field("to_node", command.toNode());
            builder.endObject();
        }
    }
}

