/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.command.AllocateAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.CancelAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class AllocationCommands {
    private static Map<String, AllocationCommand.Factory> factories = new HashMap<String, AllocationCommand.Factory>();
    private final List<AllocationCommand> commands = Lists.newArrayList();

    public static void registerFactory(String type, AllocationCommand.Factory factory) {
        factories.put(type, factory);
    }

    @Nullable
    public static <T extends AllocationCommand> AllocationCommand.Factory<T> lookupFactory(String name) {
        return factories.get(name);
    }

    public static <T extends AllocationCommand> AllocationCommand.Factory<T> lookupFactorySafe(String name) throws ElasticSearchIllegalArgumentException {
        AllocationCommand.Factory factory = factories.get(name);
        if (factory == null) {
            throw new ElasticSearchIllegalArgumentException("No allocation command factory registered for name [" + name + "]");
        }
        return factory;
    }

    public AllocationCommands(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
    }

    public AllocationCommands add(AllocationCommand ... commands) {
        if (commands != null) {
            this.commands.addAll(Arrays.asList(commands));
        }
        return this;
    }

    public List<AllocationCommand> commands() {
        return this.commands;
    }

    public void execute(RoutingAllocation allocation) throws ElasticSearchException {
        for (AllocationCommand command : this.commands) {
            command.execute(allocation);
        }
    }

    public static AllocationCommands readFrom(StreamInput in) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        int size2 = in.readVInt();
        for (int i = 0; i < size2; ++i) {
            String name = in.readString();
            commands.add(new AllocationCommand[]{AllocationCommands.lookupFactorySafe(name).readFrom(in)});
        }
        return commands;
    }

    public static void writeTo(AllocationCommands commands, StreamOutput out) throws IOException {
        out.writeVInt(commands.commands.size());
        for (AllocationCommand command : commands.commands) {
            out.writeString(command.name());
            AllocationCommands.lookupFactorySafe(command.name()).writeTo(command, out);
        }
    }

    public static AllocationCommands fromXContent(XContentParser parser) throws IOException {
        AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
        XContentParser.Token token2 = parser.currentToken();
        if (token2 == null) {
            throw new ElasticSearchParseException("No commands");
        }
        if (token2 == XContentParser.Token.FIELD_NAME) {
            if (!parser.currentName().equals("commands")) {
                throw new ElasticSearchParseException("expected field name to be named `commands`, got " + parser.currentName());
            }
            if (!parser.currentName().equals("commands")) {
                throw new ElasticSearchParseException("expected field name to be named `commands`, got " + parser.currentName());
            }
            token2 = parser.nextToken();
            if (token2 != XContentParser.Token.START_ARRAY) {
                throw new ElasticSearchParseException("commands should follow with an array element");
            }
        } else if (token2 != XContentParser.Token.START_ARRAY) {
            throw new ElasticSearchParseException("expected either field name commands, or start array, got " + (Object)((Object)token2));
        }
        while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token2 == XContentParser.Token.START_OBJECT) {
                token2 = parser.nextToken();
                String commandName = parser.currentName();
                token2 = parser.nextToken();
                commands.add(new AllocationCommand[]{AllocationCommands.lookupFactorySafe(commandName).fromXContent(parser)});
                if (parser.nextToken() == XContentParser.Token.END_OBJECT) continue;
                throw new ElasticSearchParseException("allocation command is malformed, done parsing a command, but didn't get END_OBJECT, got " + (Object)((Object)token2));
            }
            throw new ElasticSearchParseException("allocation command is malformed, got token " + (Object)((Object)token2));
        }
        return commands;
    }

    public static void toXContent(AllocationCommands commands, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("commands");
        for (AllocationCommand command : commands.commands) {
            builder.startObject();
            builder.field(command.name());
            AllocationCommands.lookupFactorySafe(command.name()).toXContent(command, builder, params);
            builder.endObject();
        }
        builder.endArray();
    }

    static {
        AllocationCommands.registerFactory("allocate", new AllocateAllocationCommand.Factory());
        AllocationCommands.registerFactory("cancel", new CancelAllocationCommand.Factory());
        AllocationCommands.registerFactory("move", new MoveAllocationCommand.Factory());
    }
}

