/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class RoutingTableValidation
implements Serializable,
Streamable {
    private boolean valid = true;
    private List<String> failures;
    private Map<String, List<String>> indicesFailures;

    public boolean valid() {
        return this.valid;
    }

    public List<String> allFailures() {
        if (this.failures().isEmpty() && this.indicesFailures().isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<String> allFailures = Lists.newArrayList(this.failures());
        for (Map.Entry<String, List<String>> entry2 : this.indicesFailures().entrySet()) {
            for (String failure2 : entry2.getValue()) {
                allFailures.add("Index [" + entry2.getKey() + "]: " + failure2);
            }
        }
        return allFailures;
    }

    public List<String> failures() {
        if (this.failures == null) {
            return ImmutableList.of();
        }
        return this.failures;
    }

    public Map<String, List<String>> indicesFailures() {
        if (this.indicesFailures == null) {
            return ImmutableMap.of();
        }
        return this.indicesFailures;
    }

    public List<String> indexFailures(String index) {
        if (this.indicesFailures == null) {
            return ImmutableList.of();
        }
        List<String> indexFailures = this.indicesFailures.get(index);
        if (indexFailures == null) {
            return ImmutableList.of();
        }
        return indexFailures;
    }

    public void addFailure(String failure2) {
        this.valid = false;
        if (this.failures == null) {
            this.failures = Lists.newArrayList();
        }
        this.failures.add(failure2);
    }

    public void addIndexFailure(String index, String failure2) {
        List<String> indexFailures;
        this.valid = false;
        if (this.indicesFailures == null) {
            this.indicesFailures = Maps.newHashMap();
        }
        if ((indexFailures = this.indicesFailures.get(index)) == null) {
            indexFailures = Lists.newArrayList();
            this.indicesFailures.put(index, indexFailures);
        }
        indexFailures.add(failure2);
    }

    public String toString() {
        return this.allFailures().toString();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int i;
        this.valid = in.readBoolean();
        int size2 = in.readVInt();
        if (size2 == 0) {
            this.failures = ImmutableList.of();
        } else {
            this.failures = Lists.newArrayListWithCapacity(size2);
            for (i = 0; i < size2; ++i) {
                this.failures.add(in.readString());
            }
        }
        size2 = in.readVInt();
        if (size2 == 0) {
            this.indicesFailures = ImmutableMap.of();
        } else {
            this.indicesFailures = Maps.newHashMap();
            for (i = 0; i < size2; ++i) {
                String index = in.readString();
                int size22 = in.readVInt();
                ArrayList<String> indexFailures = Lists.newArrayListWithCapacity(size22);
                for (int j = 0; j < size22; ++j) {
                    indexFailures.add(in.readString());
                }
                this.indicesFailures.put(index, indexFailures);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.valid);
        if (this.failures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.failures.size());
            for (String string2 : this.failures) {
                out.writeString(string2);
            }
        }
        if (this.indicesFailures == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.indicesFailures.size());
            for (Map.Entry entry2 : this.indicesFailures.entrySet()) {
                out.writeString((String)entry2.getKey());
                out.writeVInt(((List)entry2.getValue()).size());
                for (String failure3 : (List)entry2.getValue()) {
                    out.writeString(failure3);
                }
            }
        }
    }
}

