/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.Lists;

public class RoutingNode
implements Iterable<MutableShardRouting> {
    private final String nodeId;
    private final DiscoveryNode node;
    private final List<MutableShardRouting> shards;

    public RoutingNode(String nodeId, DiscoveryNode node) {
        this(nodeId, node, new ArrayList<MutableShardRouting>());
    }

    public RoutingNode(String nodeId, DiscoveryNode node, List<MutableShardRouting> shards) {
        this.nodeId = nodeId;
        this.node = node;
        this.shards = shards;
    }

    @Override
    public Iterator<MutableShardRouting> iterator() {
        return Iterators.unmodifiableIterator(this.shards.iterator());
    }

    Iterator<MutableShardRouting> mutableIterator() {
        return this.shards.iterator();
    }

    public DiscoveryNode node() {
        return this.node;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int size() {
        return this.shards.size();
    }

    void add(MutableShardRouting shard) {
        for (MutableShardRouting shardRouting : this.shards) {
            if (!shardRouting.shardId().equals(shard.shardId())) continue;
            throw new ElasticSearchIllegalStateException("Trying to add a shard [" + shard.shardId().index().name() + "][" + shard.shardId().id() + "] to a node [" + this.nodeId + "] where it already exists");
        }
        this.shards.add(shard);
    }

    public int numberOfShardsWithState(ShardRoutingState ... states) {
        int count2 = 0;
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                ++count2;
            }
        }
        return count2;
    }

    public List<MutableShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<MutableShardRouting> shardsWithState(String index, ShardRoutingState ... states) {
        ArrayList<MutableShardRouting> shards = Lists.newArrayList();
        for (MutableShardRouting shardEntry : this) {
            if (!shardEntry.index().equals(index)) continue;
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public int numberOfOwningShards() {
        int count2 = 0;
        for (MutableShardRouting shardEntry : this) {
            if (shardEntry.state() == ShardRoutingState.RELOCATING) continue;
            ++count2;
        }
        return count2;
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("-----node_id[").append(this.nodeId).append("][" + (this.node == null ? "X" : "V") + "]\n");
        for (MutableShardRouting entry2 : this.shards) {
            sb.append("--------").append(entry2.shortSummary()).append('\n');
        }
        return sb.toString();
    }

    public MutableShardRouting get(int i) {
        return this.shards.get(i);
    }

    public Collection<MutableShardRouting> copyShards() {
        return new ArrayList<MutableShardRouting>(this.shards);
    }

    public boolean isEmpty() {
        return this.shards.isEmpty();
    }
}

