/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import org.elasticsearch.cluster.routing.IllegalShardRoutingStateException;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;

public class MutableShardRouting
extends ImmutableShardRouting {
    private long hashVersion;
    private int hashCode;

    public MutableShardRouting(ShardRouting copy) {
        super(copy);
        this.hashVersion = this.version - 1L;
        this.hashCode = 0;
    }

    public MutableShardRouting(ShardRouting copy, long version) {
        super(copy);
        this.hashVersion = this.version - 1L;
        this.hashCode = 0;
        this.version = version;
    }

    public MutableShardRouting(String index, int shardId, String currentNodeId, boolean primary, ShardRoutingState state, long version) {
        super(index, shardId, currentNodeId, primary, state, version);
        this.hashVersion = this.version - 1L;
        this.hashCode = 0;
    }

    public MutableShardRouting(String index, int shardId, String currentNodeId, String relocatingNodeId, boolean primary, ShardRoutingState state, long version) {
        super(index, shardId, currentNodeId, relocatingNodeId, primary, state, version);
        this.hashVersion = this.version - 1L;
        this.hashCode = 0;
    }

    void assignToNode(String nodeId) {
        ++this.version;
        if (this.currentNodeId == null) {
            assert (this.state == ShardRoutingState.UNASSIGNED);
            this.state = ShardRoutingState.INITIALIZING;
            this.currentNodeId = nodeId;
            this.relocatingNodeId = null;
        } else if (this.state == ShardRoutingState.STARTED) {
            this.state = ShardRoutingState.RELOCATING;
            this.relocatingNodeId = nodeId;
        } else if (this.state == ShardRoutingState.RELOCATING) assert (nodeId.equals(this.relocatingNodeId));
    }

    void relocate(String relocatingNodeId) {
        ++this.version;
        assert (this.state == ShardRoutingState.STARTED);
        this.state = ShardRoutingState.RELOCATING;
        this.relocatingNodeId = relocatingNodeId;
    }

    void cancelRelocation() {
        ++this.version;
        assert (this.state == ShardRoutingState.RELOCATING);
        assert (this.assignedToNode());
        assert (this.relocatingNodeId != null);
        this.state = ShardRoutingState.STARTED;
        this.relocatingNodeId = null;
    }

    void deassignNode() {
        ++this.version;
        assert (this.state != ShardRoutingState.UNASSIGNED);
        this.state = ShardRoutingState.UNASSIGNED;
        this.currentNodeId = null;
        this.relocatingNodeId = null;
    }

    void moveToStarted() {
        ++this.version;
        assert (this.state == ShardRoutingState.INITIALIZING || this.state == ShardRoutingState.RELOCATING);
        this.relocatingNodeId = null;
        this.state = ShardRoutingState.STARTED;
    }

    void moveToPrimary() {
        ++this.version;
        if (this.primary) {
            throw new IllegalShardRoutingStateException(this, "Already primary, can't move to primary");
        }
        this.primary = true;
    }

    void moveFromPrimary() {
        ++this.version;
        if (!this.primary) {
            throw new IllegalShardRoutingStateException(this, "Not primary, can't move to replica");
        }
        this.primary = false;
    }

    @Override
    public int hashCode() {
        this.hashCode = this.hashVersion != this.version ? super.hashCode() : this.hashCode;
        this.hashVersion = this.version;
        return this.hashCode;
    }
}

