/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.PlainShardIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.jsr166y.ThreadLocalRandom;
import org.elasticsearch.index.shard.ShardId;

public class IndexShardRoutingTable
implements Iterable<ShardRouting> {
    final ShardId shardId;
    final ShardRouting primary;
    final ImmutableList<ShardRouting> primaryAsList;
    final ImmutableList<ShardRouting> replicas;
    final ImmutableList<ShardRouting> shards;
    final ImmutableList<ShardRouting> activeShards;
    final ImmutableList<ShardRouting> assignedShards;
    final ImmutableList<ShardRouting> allInitializingShards;
    final AtomicInteger counter;
    final boolean primaryAllocatedPostApi;
    private volatile Map<AttributesKey, AttributesRoutings> activeShardsByAttributes = ImmutableMap.of();
    private volatile Map<AttributesKey, AttributesRoutings> initializingShardsByAttributes = ImmutableMap.of();
    private final Object shardsByAttributeMutex = new Object();

    IndexShardRoutingTable(ShardId shardId, ImmutableList<ShardRouting> shards, boolean primaryAllocatedPostApi) {
        this.shardId = shardId;
        this.shards = shards;
        this.primaryAllocatedPostApi = primaryAllocatedPostApi;
        this.counter = new AtomicInteger(ThreadLocalRandom.current().nextInt(shards.size()));
        ShardRouting primary = null;
        ImmutableList.Builder replicas = ImmutableList.builder();
        ImmutableList.Builder activeShards = ImmutableList.builder();
        ImmutableList.Builder assignedShards = ImmutableList.builder();
        ImmutableList.Builder allInitializingShards = ImmutableList.builder();
        for (ShardRouting shard : shards) {
            if (shard.primary()) {
                primary = shard;
            } else {
                replicas.add(shard);
            }
            if (shard.active()) {
                activeShards.add(shard);
            }
            if (shard.initializing()) {
                allInitializingShards.add(shard);
            }
            if (shard.relocating()) {
                allInitializingShards.add(new ImmutableShardRouting(shard.index(), shard.id(), shard.relocatingNodeId(), shard.currentNodeId(), shard.primary(), ShardRoutingState.INITIALIZING, shard.version()));
            }
            if (!shard.assignedToNode()) continue;
            assignedShards.add(shard);
        }
        this.primary = primary;
        this.primaryAsList = primary != null ? ImmutableList.of(primary) : ImmutableList.of();
        this.replicas = replicas.build();
        this.activeShards = activeShards.build();
        this.assignedShards = assignedShards.build();
        this.allInitializingShards = allInitializingShards.build();
    }

    public IndexShardRoutingTable normalizeVersions() {
        if (this.shards.isEmpty()) {
            return this;
        }
        if (this.shards.size() == 1) {
            return this;
        }
        long highestVersion = ((ShardRouting)this.shards.get(0)).version();
        boolean requiresNormalization = false;
        for (int i = 1; i < this.shards.size(); ++i) {
            if (((ShardRouting)this.shards.get(i)).version() != highestVersion) {
                requiresNormalization = true;
            }
            if (((ShardRouting)this.shards.get(i)).version() <= highestVersion) continue;
            highestVersion = ((ShardRouting)this.shards.get(i)).version();
        }
        if (!requiresNormalization) {
            return this;
        }
        ArrayList shardRoutings = new ArrayList(this.shards.size());
        for (int i = 0; i < this.shards.size(); ++i) {
            if (((ShardRouting)this.shards.get(i)).version() == highestVersion) {
                shardRoutings.add(this.shards.get(i));
                continue;
            }
            shardRoutings.add(new ImmutableShardRouting((ShardRouting)this.shards.get(i), highestVersion));
        }
        return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(shardRoutings), this.primaryAllocatedPostApi);
    }

    public boolean primaryAllocatedPostApi() {
        return this.primaryAllocatedPostApi;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public ShardId getShardId() {
        return this.shardId();
    }

    @Override
    public UnmodifiableIterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }

    public int size() {
        return this.shards.size();
    }

    public int getSize() {
        return this.size();
    }

    public ImmutableList<ShardRouting> shards() {
        return this.shards;
    }

    public ImmutableList<ShardRouting> getShards() {
        return this.shards();
    }

    public ImmutableList<ShardRouting> activeShards() {
        return this.activeShards;
    }

    public ImmutableList<ShardRouting> getActiveShards() {
        return this.activeShards();
    }

    public ImmutableList<ShardRouting> assignedShards() {
        return this.assignedShards;
    }

    public ImmutableList<ShardRouting> getAssignedShards() {
        return this.assignedShards;
    }

    public int countWithState(ShardRoutingState state) {
        int count2 = 0;
        for (ShardRouting shard : this) {
            if (state != shard.state()) continue;
            ++count2;
        }
        return count2;
    }

    public ShardIterator shardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.shards, this.pickIndex());
    }

    public ShardIterator shardsIt() {
        return new PlainShardIterator(this.shardId, this.shards);
    }

    public ShardIterator shardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.shards, index);
    }

    public ShardIterator activeShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.activeShards, this.pickIndex());
    }

    public ShardIterator activeShardsIt() {
        return new PlainShardIterator(this.shardId, this.activeShards);
    }

    public ShardIterator activeShardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.activeShards, index);
    }

    public ShardIterator activeInitializingShardsRandomIt() {
        return this.activeInitializingShardsIt(this.pickIndex());
    }

    public ShardIterator activeInitializingShardsIt(int index) {
        if (this.allInitializingShards.isEmpty()) {
            return new PlainShardIterator(this.shardId, this.activeShards, index);
        }
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        this.addToListFromIndex(this.activeShards, ordered, index);
        ordered.addAll(this.allInitializingShards);
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator assignedShardsRandomIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards, this.pickIndex());
    }

    public ShardIterator assignedShardsIt() {
        return new PlainShardIterator(this.shardId, this.assignedShards);
    }

    public ShardIterator assignedShardsIt(int index) {
        return new PlainShardIterator(this.shardId, this.assignedShards, index);
    }

    public ShardIterator primaryShardIt() {
        return new PlainShardIterator(this.shardId, this.primaryAsList);
    }

    public ShardIterator primaryActiveInitializingShardIt() {
        if (!(this.primaryAsList.isEmpty() || ((ShardRouting)this.primaryAsList.get(0)).active() || ((ShardRouting)this.primaryAsList.get(0)).initializing())) {
            ImmutableList<ShardRouting> primaryList = ImmutableList.of();
            return new PlainShardIterator(this.shardId, primaryList);
        }
        return this.primaryShardIt();
    }

    public ShardIterator primaryFirstActiveInitializingShardsIt() {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        int index = Math.abs(this.pickIndex());
        for (int i = 0; i < this.activeShards.size(); ++i) {
            int loc = (index + i) % this.activeShards.size();
            ShardRouting shardRouting = (ShardRouting)this.activeShards.get(loc);
            ordered.add(shardRouting);
            if (!shardRouting.primary()) continue;
            ordered.set(i, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator onlyNodeActiveInitializingShardsIt(String nodeId) {
        ShardRouting shardRouting;
        int i;
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        for (i = 0; i < this.activeShards.size(); ++i) {
            shardRouting = (ShardRouting)this.activeShards.get(i);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        for (i = 0; i < this.allInitializingShards.size(); ++i) {
            shardRouting = (ShardRouting)this.allInitializingShards.get(i);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.add(shardRouting);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardIterator preferNodeActiveInitializingShardsIt(String nodeId) {
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(this.activeShards.size() + this.allInitializingShards.size());
        int index = this.pickIndex();
        for (int i = 0; i < this.activeShards.size(); ++i) {
            int loc = (index + i) % this.activeShards.size();
            ShardRouting shardRouting = (ShardRouting)this.activeShards.get(loc);
            ordered.add(shardRouting);
            if (!nodeId.equals(shardRouting.currentNodeId())) continue;
            ordered.set(i, ordered.get(0));
            ordered.set(0, shardRouting);
        }
        if (!this.allInitializingShards.isEmpty()) {
            ordered.addAll(this.allInitializingShards);
        }
        return new PlainShardIterator(this.shardId, ordered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getActiveAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.activeShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from2 = new ArrayList<ShardRouting>(this.activeShards);
                ImmutableList<ShardRouting> to2 = IndexShardRoutingTable.collectAttributeShards(key, nodes, from2);
                shardRoutings = new AttributesRoutings(to2, ImmutableList.copyOf(from2));
                this.activeShardsByAttributes = MapBuilder.newMapBuilder(this.activeShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributesRoutings getInitializingAttribute(AttributesKey key, DiscoveryNodes nodes) {
        AttributesRoutings shardRoutings = this.initializingShardsByAttributes.get(key);
        if (shardRoutings == null) {
            Object object = this.shardsByAttributeMutex;
            synchronized (object) {
                ArrayList<ShardRouting> from2 = new ArrayList<ShardRouting>(this.allInitializingShards);
                ImmutableList<ShardRouting> to2 = IndexShardRoutingTable.collectAttributeShards(key, nodes, from2);
                shardRoutings = new AttributesRoutings(to2, ImmutableList.copyOf(from2));
                this.initializingShardsByAttributes = MapBuilder.newMapBuilder(this.initializingShardsByAttributes).put(key, shardRoutings).immutableMap();
            }
        }
        return shardRoutings;
    }

    private static ImmutableList<ShardRouting> collectAttributeShards(AttributesKey key, DiscoveryNodes nodes, ArrayList<ShardRouting> from2) {
        ArrayList<ShardRouting> to2 = new ArrayList<ShardRouting>();
        for (String attribute : key.attributes) {
            String localAttributeValue = nodes.localNode().attributes().get(attribute);
            if (localAttributeValue == null) continue;
            Iterator<ShardRouting> iterator2 = from2.iterator();
            while (iterator2.hasNext()) {
                ShardRouting fromShard = iterator2.next();
                DiscoveryNode discoveryNode = nodes.get(fromShard.currentNodeId());
                if (discoveryNode == null) {
                    iterator2.remove();
                    continue;
                }
                if (!localAttributeValue.equals(discoveryNode.attributes().get(attribute))) continue;
                iterator2.remove();
                to2.add(fromShard);
            }
        }
        return ImmutableList.copyOf(to2);
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(String[] attributes, DiscoveryNodes nodes) {
        return this.preferAttributesActiveInitializingShardsIt(attributes, nodes, this.pickIndex());
    }

    public ShardIterator preferAttributesActiveInitializingShardsIt(String[] attributes, DiscoveryNodes nodes, int index) {
        AttributesKey key = new AttributesKey(attributes);
        AttributesRoutings activeRoutings = this.getActiveAttribute(key, nodes);
        AttributesRoutings initializingRoutings = this.getInitializingAttribute(key, nodes);
        ArrayList<ShardRouting> ordered = new ArrayList<ShardRouting>(activeRoutings.totalSize + initializingRoutings.totalSize);
        index = Math.abs(index);
        this.addToListFromIndex(activeRoutings.withSameAttribute, ordered, index);
        this.addToListFromIndex(activeRoutings.withoutSameAttribute, ordered, index);
        this.addToListFromIndex(initializingRoutings.withSameAttribute, ordered, index);
        this.addToListFromIndex(initializingRoutings.withoutSameAttribute, ordered, index);
        return new PlainShardIterator(this.shardId, ordered);
    }

    public ShardRouting primaryShard() {
        return this.primary;
    }

    public List<ShardRouting> replicaShards() {
        return this.replicas;
    }

    public List<ShardRouting> replicaShardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (ShardRouting shardEntry : this.replicas) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    public List<ShardRouting> shardsWithState(ShardRoutingState ... states) {
        ArrayList<ShardRouting> shards = Lists.newArrayList();
        for (ShardRouting shardEntry : this) {
            for (ShardRoutingState state : states) {
                if (shardEntry.state() != state) continue;
                shards.add(shardEntry);
            }
        }
        return shards;
    }

    private void addToListFromIndex(List from2, List to2, int index) {
        index = Math.abs(index);
        for (int i = 0; i < from2.size(); ++i) {
            int loc = (index + i) % from2.size();
            to2.add(from2.get(loc));
        }
    }

    private int pickIndex() {
        return Math.abs(this.counter.incrementAndGet());
    }

    public static class Builder {
        private ShardId shardId;
        private final List<ShardRouting> shards;
        private boolean primaryAllocatedPostApi;

        public Builder(IndexShardRoutingTable indexShard) {
            this.shardId = indexShard.shardId;
            this.shards = Lists.newArrayList(indexShard.shards);
            this.primaryAllocatedPostApi = indexShard.primaryAllocatedPostApi();
        }

        public Builder(ShardId shardId, boolean primaryAllocatedPostApi) {
            this.shardId = shardId;
            this.shards = Lists.newArrayList();
            this.primaryAllocatedPostApi = primaryAllocatedPostApi;
        }

        public Builder addShard(ImmutableShardRouting shardEntry) {
            for (ShardRouting shard : this.shards) {
                if (!shard.assignedToNode() || !shardEntry.assignedToNode() || !shard.currentNodeId().equals(shardEntry.currentNodeId())) continue;
                return this;
            }
            this.shards.add(shardEntry);
            return this;
        }

        public Builder removeShard(ShardRouting shardEntry) {
            this.shards.remove(shardEntry);
            return this;
        }

        public IndexShardRoutingTable build() {
            if (!this.primaryAllocatedPostApi) {
                for (ShardRouting shardRouting : this.shards) {
                    if (!shardRouting.primary() || !shardRouting.active()) continue;
                    this.primaryAllocatedPostApi = true;
                }
            }
            return new IndexShardRoutingTable(this.shardId, ImmutableList.copyOf(this.shards), this.primaryAllocatedPostApi);
        }

        public static IndexShardRoutingTable readFrom(StreamInput in) throws IOException {
            String index = in.readString();
            return Builder.readFromThin(in, index);
        }

        public static IndexShardRoutingTable readFromThin(StreamInput in, String index) throws IOException {
            int iShardId = in.readVInt();
            boolean allocatedPostApi = in.readBoolean();
            Builder builder = new Builder(new ShardId(index, iShardId), allocatedPostApi);
            int size2 = in.readVInt();
            for (int i = 0; i < size2; ++i) {
                ImmutableShardRouting shard = ImmutableShardRouting.readShardRoutingEntry(in, index, iShardId);
                builder.addShard(shard);
            }
            return builder.build();
        }

        public static void writeTo(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeString(indexShard.shardId().index().name());
            Builder.writeToThin(indexShard, out);
        }

        public static void writeToThin(IndexShardRoutingTable indexShard, StreamOutput out) throws IOException {
            out.writeVInt(indexShard.shardId.id());
            out.writeBoolean(indexShard.primaryAllocatedPostApi());
            out.writeVInt(indexShard.shards.size());
            for (ShardRouting entry2 : indexShard) {
                entry2.writeToThin(out);
            }
        }
    }

    static class AttributesRoutings {
        public final ImmutableList<ShardRouting> withSameAttribute;
        public final ImmutableList<ShardRouting> withoutSameAttribute;
        public final int totalSize;

        AttributesRoutings(ImmutableList<ShardRouting> withSameAttribute, ImmutableList<ShardRouting> withoutSameAttribute) {
            this.withSameAttribute = withSameAttribute;
            this.withoutSameAttribute = withoutSameAttribute;
            this.totalSize = withoutSameAttribute.size() + withSameAttribute.size();
        }
    }

    static class AttributesKey {
        final String[] attributes;

        AttributesKey(String[] attributes) {
            this.attributes = attributes;
        }

        public int hashCode() {
            return Arrays.hashCode(this.attributes);
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.attributes, ((AttributesKey)obj).attributes);
        }
    }
}

