/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Collection;
import java.util.Iterator;
import org.elasticsearch.cluster.routing.ShardIterator;

public class GroupShardsIterator
implements Iterable<ShardIterator> {
    private final Collection<ShardIterator> iterators;

    public GroupShardsIterator(Collection<ShardIterator> iterators) {
        this.iterators = iterators;
    }

    public int totalSize() {
        int size2 = 0;
        for (ShardIterator shard : this.iterators) {
            size2 += shard.size();
        }
        return size2;
    }

    public int totalSizeWith1ForEmpty() {
        int size2 = 0;
        for (ShardIterator shard : this.iterators) {
            int sizeActive = shard.size();
            if (sizeActive == 0) {
                ++size2;
                continue;
            }
            size2 += sizeActive;
        }
        return size2;
    }

    public int size() {
        return this.iterators.size();
    }

    public Collection<ShardIterator> iterators() {
        return this.iterators;
    }

    @Override
    public Iterator<ShardIterator> iterator() {
        return this.iterators.iterator();
    }
}

