/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.node;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class DiscoveryNodeFilters {
    private final Map<String, String[]> filters;
    private final OpType opType;

    public static DiscoveryNodeFilters buildFromSettings(OpType opType, String prefix, Settings settings) {
        return DiscoveryNodeFilters.buildFromKeyValue(opType, settings.getByPrefix(prefix).getAsMap());
    }

    public static DiscoveryNodeFilters buildFromKeyValue(OpType opType, Map<String, String> filters) {
        HashMap<String, String[]> bFilters = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry2 : filters.entrySet()) {
            String[] values2 = Strings.splitStringByCommaToArray(entry2.getValue());
            if (values2.length <= 0) continue;
            bFilters.put(entry2.getKey(), values2);
        }
        if (bFilters.isEmpty()) {
            return null;
        }
        return new DiscoveryNodeFilters(opType, bFilters);
    }

    DiscoveryNodeFilters(OpType opType, Map<String, String[]> filters) {
        this.opType = opType;
        this.filters = filters;
    }

    public boolean match(DiscoveryNode node) {
        for (Map.Entry<String, String[]> entry2 : this.filters.entrySet()) {
            InetSocketTransportAddress inetAddress;
            String attr = entry2.getKey();
            String[] values2 = entry2.getValue();
            if ("_ip".equals(attr)) {
                if (!(node.address() instanceof InetSocketTransportAddress)) {
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                inetAddress = (InetSocketTransportAddress)node.address();
                for (String value2 : values2) {
                    if (Regex.simpleMatch(value2, inetAddress.address().getAddress().getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_host".equals(attr)) {
                if (!(node.address() instanceof InetSocketTransportAddress)) {
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                inetAddress = (InetSocketTransportAddress)node.address();
                for (String value2 : values2) {
                    if (Regex.simpleMatch(value2, inetAddress.address().getHostName())) {
                        if (this.opType == OpType.OR) {
                            return true;
                        }
                    } else if (this.opType == OpType.AND) {
                        return false;
                    }
                    if (Regex.simpleMatch(value2, inetAddress.address().getAddress().getHostAddress())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_id".equals(attr)) {
                for (String value3 : values2) {
                    if (node.id().equals(value3)) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            if ("_name".equals(attr) || "name".equals(attr)) {
                for (String value4 : values2) {
                    if (Regex.simpleMatch(value4, node.name())) {
                        if (this.opType != OpType.OR) continue;
                        return true;
                    }
                    if (this.opType != OpType.AND) continue;
                    return false;
                }
                continue;
            }
            String nodeAttributeValue = node.attributes().get(attr);
            if (nodeAttributeValue == null) {
                if (this.opType != OpType.AND) continue;
                return false;
            }
            for (String value2 : values2) {
                if (Regex.simpleMatch(value2, nodeAttributeValue)) {
                    if (this.opType != OpType.OR) continue;
                    return true;
                }
                if (this.opType != OpType.AND) continue;
                return false;
            }
        }
        return this.opType != OpType.OR;
    }

    public static enum OpType {
        AND,
        OR;

    }
}

