/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidAliasNameException;

public class MetaDataIndexAliasesService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    @Inject
    public MetaDataIndexAliasesService(Settings settings, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, final ClusterStateUpdateListener listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", Priority.URGENT, new AckedClusterStateUpdateTask(){

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new ClusterStateUpdateResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) {
                ArrayList<String> indicesToClose = Lists.newArrayList();
                HashMap<String, IndexService> indices = Maps.newHashMap();
                try {
                    ClusterState updatedState;
                    for (AliasAction aliasAction : request.actions()) {
                        if (!Strings.hasText(aliasAction.alias()) || !Strings.hasText(aliasAction.index())) {
                            throw new ElasticSearchIllegalArgumentException("Index name and alias name are required");
                        }
                        if (!currentState.metaData().hasIndex(aliasAction.index())) {
                            throw new IndexMissingException(new Index(aliasAction.index()));
                        }
                        if (currentState.metaData().hasIndex(aliasAction.alias())) {
                            throw new InvalidAliasNameException(new Index(aliasAction.index()), aliasAction.alias(), "an index exists with the same name as the alias");
                        }
                        if (aliasAction.indexRouting() == null || aliasAction.indexRouting().indexOf(44) == -1) continue;
                        throw new ElasticSearchIllegalArgumentException("alias [" + aliasAction.alias() + "] has several routing values associated with it");
                    }
                    boolean changed = false;
                    MetaData.Builder builder = MetaData.builder(currentState.metaData());
                    for (AliasAction aliasAction : request.actions()) {
                        IndexMetaData indexMetaData = builder.get(aliasAction.index());
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(aliasAction.index()));
                        }
                        IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData);
                        if (aliasAction.actionType() == AliasAction.Type.ADD) {
                            String filter2 = aliasAction.filter();
                            if (Strings.hasLength(filter2)) {
                                IndexService indexService = (IndexService)indices.get(indexMetaData.index());
                                if (indexService == null) {
                                    indexService = MetaDataIndexAliasesService.this.indicesService.indexService(indexMetaData.index());
                                    if (indexService == null) {
                                        try {
                                            indexService = MetaDataIndexAliasesService.this.indicesService.createIndex(indexMetaData.index(), indexMetaData.settings(), MetaDataIndexAliasesService.this.clusterService.localNode().id());
                                            if (indexMetaData.mappings().containsKey("_default_")) {
                                                indexService.mapperService().merge("_default_", indexMetaData.mappings().get("_default_").source(), false);
                                            }
                                            for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.mappings().values()) {
                                                MappingMetaData mappingMetaData = (MappingMetaData)objectCursor.value;
                                                indexService.mapperService().merge(mappingMetaData.type(), mappingMetaData.source(), false);
                                            }
                                        }
                                        catch (Exception e) {
                                            MetaDataIndexAliasesService.this.logger.warn("[{}] failed to temporary create in order to apply alias action", e, indexMetaData.index());
                                            continue;
                                        }
                                        indicesToClose.add(indexMetaData.index());
                                    }
                                    indices.put(indexMetaData.index(), indexService);
                                }
                                IndexQueryParserService indexQueryParser = indexService.queryParserService();
                                try {
                                    XContentParser xContentParser = XContentFactory.xContent(filter2).createParser(filter2);
                                    try {
                                        indexQueryParser.parseInnerFilter(xContentParser);
                                    }
                                    finally {
                                        xContentParser.close();
                                    }
                                }
                                catch (Throwable throwable) {
                                    throw new ElasticSearchIllegalArgumentException("failed to parse filter for [" + aliasAction.alias() + "]", throwable);
                                }
                            }
                            AliasMetaData newAliasMd = AliasMetaData.newAliasMetaDataBuilder(aliasAction.alias()).filter(filter2).indexRouting(aliasAction.indexRouting()).searchRouting(aliasAction.searchRouting()).build();
                            AliasMetaData aliasMd = indexMetaData.aliases().get(aliasAction.alias());
                            if (aliasMd != null && aliasMd.equals(newAliasMd)) continue;
                            indexMetaDataBuilder.putAlias(newAliasMd);
                        } else if (aliasAction.actionType() == AliasAction.Type.REMOVE) {
                            if (!indexMetaData.aliases().containsKey(aliasAction.alias())) continue;
                            indexMetaDataBuilder.removerAlias(aliasAction.alias());
                        }
                        changed = true;
                        builder.put(indexMetaDataBuilder);
                    }
                    if (changed && !(updatedState = ClusterState.builder(currentState).metaData(builder).build()).metaData().aliases().equals(currentState.metaData().aliases())) {
                        ClusterState len$ = updatedState;
                        return len$;
                    }
                    ClusterState clusterState = currentState;
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataIndexAliasesService.this.indicesService.removeIndex(index, "created for alias processing");
                    }
                }
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }
}

