/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.ObjectArrayList;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.RestStatus;

public class MetaData
implements Iterable<IndexMetaData> {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    public static final String SETTING_READ_ONLY = "cluster.blocks.read_only";
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA);
    public static final MetaData EMPTY_META_DATA = MetaData.builder().build();
    private final String uuid;
    private final long version;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final ImmutableOpenMap<String, IndexMetaData> indices;
    private final ImmutableOpenMap<String, IndexTemplateMetaData> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final int numberOfShards;
    private final String[] allIndices;
    private final String[] allOpenIndices;
    private final ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> aliases;
    private final ImmutableOpenMap<String, String[]> aliasAndIndexToIndexMap;

    public static void registerFactory(String type, Custom.Factory factory) {
        customFactories.put(type, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type) {
        return customFactories.get(type);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type) throws ElasticSearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type);
        if (factory == null) {
            throw new ElasticSearchIllegalArgumentException("No custom index metadata factory registered for type [" + type + "]");
        }
        return factory;
    }

    MetaData(String uuid, long version, Settings transientSettings, Settings persistentSettings, ImmutableOpenMap<String, IndexMetaData> indices, ImmutableOpenMap<String, IndexTemplateMetaData> templates, ImmutableOpenMap<String, Custom> customs) {
        this.uuid = uuid;
        this.version = version;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = ImmutableSettings.settingsBuilder().put(persistentSettings).put(transientSettings).build();
        this.indices = indices;
        this.customs = customs;
        this.templates = templates;
        int totalNumberOfShards = 0;
        int numberOfShards = 0;
        int numAliases = 0;
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            totalNumberOfShards += ((IndexMetaData)objectCursor.value).totalNumberOfShards();
            numberOfShards += ((IndexMetaData)objectCursor.value).numberOfShards();
            numAliases += ((IndexMetaData)objectCursor.value).aliases().size();
        }
        this.totalNumberOfShards = totalNumberOfShards;
        this.numberOfShards = numberOfShards;
        ArrayList<String> allIndicesLst = Lists.newArrayList();
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            allIndicesLst.add(((IndexMetaData)objectCursor.value).index());
        }
        this.allIndices = allIndicesLst.toArray(new String[allIndicesLst.size()]);
        int n = allIndicesLst.size();
        ArrayList<String> arrayList = Lists.newArrayList();
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            if (indexMetaData.state() != IndexMetaData.State.OPEN) continue;
            arrayList.add(indexMetaData.index());
        }
        this.allOpenIndices = arrayList.toArray(new String[arrayList.size()]);
        ImmutableOpenMap.Builder tmpAliases = ImmutableOpenMap.builder(numAliases);
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            String index = indexMetaData.index();
            for (ObjectCursor<AliasMetaData> objectCursor2 : indexMetaData.aliases().values()) {
                AliasMetaData aliasMd = (AliasMetaData)objectCursor2.value;
                ImmutableOpenMap.Builder<String, AliasMetaData> indexAliasMap = (ImmutableOpenMap.Builder<String, AliasMetaData>)tmpAliases.get(aliasMd.alias());
                if (indexAliasMap == null) {
                    indexAliasMap = ImmutableOpenMap.builder(indices.size());
                    tmpAliases.put(aliasMd.alias(), indexAliasMap);
                }
                indexAliasMap.put(index, aliasMd);
            }
        }
        for (ObjectCursor objectCursor : tmpAliases.keys()) {
            String string2 = (String)objectCursor.value;
            ImmutableOpenMap map2 = ((ImmutableOpenMap.Builder)tmpAliases.get(string2)).cast().build();
            tmpAliases.put(string2, map2);
        }
        this.aliases = tmpAliases.cast().build();
        ImmutableOpenMap.Builder<String, Object> builder = ImmutableOpenMap.builder(numAliases + n);
        for (ObjectCursor<IndexMetaData> objectCursor : indices.values()) {
            IndexMetaData indexMetaData = (IndexMetaData)objectCursor.value;
            ObjectArrayList<String> indicesLst = (ObjectArrayList<String>)builder.get(indexMetaData.index());
            if (indicesLst == null) {
                indicesLst = new ObjectArrayList<String>();
                builder.put(indexMetaData.index(), indicesLst);
            }
            indicesLst.add(indexMetaData.index());
            for (ObjectCursor cursor1 : indexMetaData.aliases().keys()) {
                String alias = (String)cursor1.value;
                indicesLst = (ObjectArrayList<String>)builder.get(alias);
                if (indicesLst == null) {
                    indicesLst = new ObjectArrayList<String>();
                    builder.put(alias, indicesLst);
                }
                indicesLst.add(indexMetaData.index());
            }
        }
        for (ObjectObjectCursor objectObjectCursor : builder) {
            String[] indicesLst = (String[])((ObjectArrayList)objectObjectCursor.value).toArray(String.class);
            builder.put((String)objectObjectCursor.key, indicesLst);
        }
        this.aliasAndIndexToIndexMap = builder.cast().build();
    }

    public long version() {
        return this.version;
    }

    public String uuid() {
        return this.uuid;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, AliasMetaData>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, ImmutableList<AliasMetaData>> findAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        boolean matchAllAliases = aliases.length == 0;
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Iterable<String> intersection2 = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection2) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = Lists.newArrayList();
            for (ObjectCursor<AliasMetaData> objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData value2 = (AliasMetaData)objectCursor.value;
                if (!matchAllAliases && !Regex.simpleMatch(aliases, value2.alias())) continue;
                filteredValues.add(value2);
            }
            if (filteredValues.isEmpty()) continue;
            mapBuilder.put(index, ImmutableList.copyOf(filteredValues));
        }
        return mapBuilder.build();
    }

    public boolean hasAliases(String[] aliases, String[] concreteIndices) {
        assert (aliases != null);
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return false;
        }
        Iterable<String> intersection2 = HppcMaps.intersection(ObjectOpenHashSet.from(concreteIndices), this.indices.keys());
        for (String index : intersection2) {
            IndexMetaData indexMetaData = this.indices.get(index);
            ArrayList<AliasMetaData> filteredValues = Lists.newArrayList();
            for (ObjectCursor<AliasMetaData> objectCursor : indexMetaData.getAliases().values()) {
                AliasMetaData value2 = (AliasMetaData)objectCursor.value;
                if (!Regex.simpleMatch(aliases, value2.alias())) continue;
                filteredValues.add(value2);
            }
            if (filteredValues.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String[] concreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteAllIndices() {
        return this.concreteAllIndices();
    }

    public String[] concreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        ImmutableOpenMap<String, AliasMetaData> indexAliases = this.aliases.get(aliasOrIndex);
        if (indexAliases == null || indexAliases.isEmpty()) {
            return routing;
        }
        if (indexAliases.size() > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexAliases.keys().toArray(String.class)) + "], can't execute a single index op");
        }
        AliasMetaData aliasMd = (AliasMetaData)indexAliases.values().iterator().next().value;
        if (aliasMd.indexRouting() != null) {
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new ElasticSearchIllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            routing = aliasMd.indexRouting();
        }
        if (routing != null && routing.indexOf(44) != -1) {
            throw new ElasticSearchIllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + routing + "] that resolved to several routing values, rejecting operation");
        }
        return routing;
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String aliasOrIndex) {
        return this.resolveSearchRouting(routing, this.convertFromWildcards(new String[]{aliasOrIndex}, true, IgnoreIndices.MISSING));
    }

    public Map<String, Set<String>> resolveSearchRouting(@Nullable String routing, String[] aliasesOrIndices) {
        if (this.isAllIndices(aliasesOrIndices)) {
            return this.resolveSearchRoutingAllIndices(routing);
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, true, IgnoreIndices.MISSING)).length == 1) {
            return this.resolveSearchRoutingSingleValue(routing, aliasesOrIndices[0]);
        }
        HashMap routings = null;
        Set<String> paramRouting = null;
        HashSet<Object> norouting = new HashSet<Object>();
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        for (String aliasOrIndex : aliasesOrIndices) {
            ImmutableOpenMap<String, AliasMetaData> indexToRoutingMap = this.aliases.get(aliasOrIndex);
            if (indexToRoutingMap != null && !indexToRoutingMap.isEmpty()) {
                for (ObjectObjectCursor<String, AliasMetaData> objectObjectCursor : indexToRoutingMap) {
                    HashSet<Object> r;
                    if (norouting.contains(objectObjectCursor.key)) continue;
                    if (!((AliasMetaData)objectObjectCursor.value).searchRoutingValues().isEmpty()) {
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        if ((r = (HashSet<String>)routings.get(objectObjectCursor.key)) == null) {
                            r = new HashSet<String>();
                            routings.put(objectObjectCursor.key, r);
                        }
                        r.addAll(((AliasMetaData)objectObjectCursor.value).searchRoutingValues());
                        if (paramRouting != null) {
                            r.retainAll(paramRouting);
                        }
                        if (!r.isEmpty()) continue;
                        routings.remove(objectObjectCursor.key);
                        continue;
                    }
                    if (norouting.contains(objectObjectCursor.key)) continue;
                    norouting.add(objectObjectCursor.key);
                    if (paramRouting != null) {
                        r = new HashSet<String>(paramRouting);
                        if (routings == null) {
                            routings = Maps.newHashMap();
                        }
                        routings.put(objectObjectCursor.key, r);
                        continue;
                    }
                    if (routings == null) continue;
                    routings.remove(objectObjectCursor.key);
                }
                continue;
            }
            if (norouting.contains(aliasOrIndex)) continue;
            norouting.add(aliasOrIndex);
            if (paramRouting != null) {
                HashSet<String> r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put(aliasOrIndex, r);
                continue;
            }
            if (routings == null) continue;
            routings.remove(aliasOrIndex);
        }
        if (routings == null || routings.isEmpty()) {
            return null;
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingSingleValue(@Nullable String routing, String aliasOrIndex) {
        ImmutableOpenMap<String, AliasMetaData> indexToRoutingMap;
        Map<String, Set<String>> routings = null;
        Set<String> paramRouting = null;
        if (routing != null) {
            paramRouting = Strings.splitStringByCommaToSet(routing);
        }
        if ((indexToRoutingMap = this.aliases.get(aliasOrIndex)) != null && !indexToRoutingMap.isEmpty()) {
            for (ObjectObjectCursor<String, AliasMetaData> objectObjectCursor : indexToRoutingMap) {
                HashSet<String> r;
                if (!((AliasMetaData)objectObjectCursor.value).searchRoutingValues().isEmpty()) {
                    r = new HashSet<String>(((AliasMetaData)objectObjectCursor.value).searchRoutingValues());
                    if (paramRouting != null) {
                        r.retainAll(paramRouting);
                    }
                    if (r.isEmpty()) continue;
                    if (routings == null) {
                        routings = Maps.newHashMap();
                    }
                    routings.put((String)objectObjectCursor.key, (Set<String>)r);
                    continue;
                }
                if (paramRouting == null) continue;
                r = new HashSet<String>(paramRouting);
                if (routings == null) {
                    routings = Maps.newHashMap();
                }
                routings.put((String)objectObjectCursor.key, (Set<String>)r);
            }
        } else if (paramRouting != null) {
            routings = ImmutableMap.of(aliasOrIndex, paramRouting);
        }
        return routings;
    }

    private Map<String, Set<String>> resolveSearchRoutingAllIndices(String routing) {
        if (routing != null) {
            String[] concreteIndices;
            Set<String> r = Strings.splitStringByCommaToSet(routing);
            HashMap<String, Set<String>> routings = Maps.newHashMap();
            for (String index : concreteIndices = this.concreteAllIndices()) {
                routings.put(index, r);
            }
            return routings;
        }
        return null;
    }

    public String[] concreteIndices(String[] indices) throws IndexMissingException {
        return this.concreteIndices(indices, IgnoreIndices.NONE, false);
    }

    public String[] concreteIndicesIgnoreMissing(String[] indices) {
        return this.concreteIndices(indices, IgnoreIndices.MISSING, false);
    }

    public String[] concreteIndices(String[] aliasesOrIndices, IgnoreIndices ignoreIndices, boolean allOnlyOpen) throws IndexMissingException {
        if (this.isAllIndices(aliasesOrIndices)) {
            return allOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
        }
        if ((aliasesOrIndices = this.convertFromWildcards(aliasesOrIndices, allOnlyOpen, ignoreIndices)).length == 1) {
            String aliasOrIndex = aliasesOrIndices[0];
            if (this.indices.containsKey(aliasOrIndex)) {
                return aliasesOrIndices;
            }
            String[] actualLst = this.aliasAndIndexToIndexMap.get(aliasOrIndex);
            if (actualLst == null) {
                throw new IndexMissingException(new Index(aliasOrIndex));
            }
            return actualLst;
        }
        boolean possiblyAliased = false;
        for (String index : aliasesOrIndices) {
            if (this.indices.containsKey(index)) continue;
            possiblyAliased = true;
            break;
        }
        if (!possiblyAliased) {
            return aliasesOrIndices;
        }
        HashSet<String> actualIndices = new HashSet<String>();
        for (String index : aliasesOrIndices) {
            String[] actualLst = this.aliasAndIndexToIndexMap.get(index);
            if (actualLst == null) {
                if (ignoreIndices == IgnoreIndices.MISSING) continue;
                throw new IndexMissingException(new Index(index));
            }
            for (String x2 : actualLst) {
                actualIndices.add(x2);
            }
        }
        if (actualIndices.isEmpty()) {
            throw new IndexMissingException(new Index(Arrays.toString(aliasesOrIndices)));
        }
        return actualIndices.toArray(new String[actualIndices.size()]);
    }

    public String concreteIndex(String index) throws IndexMissingException, ElasticSearchIllegalArgumentException {
        if (this.indices.containsKey(index)) {
            return index;
        }
        Object[] lst = this.aliasAndIndexToIndexMap.get(index);
        if (lst == null) {
            throw new IndexMissingException(new Index(index));
        }
        if (lst.length > 1) {
            throw new ElasticSearchIllegalArgumentException("Alias [" + index + "] has more than one indices associated with it [" + Arrays.toString(lst) + "], can't execute a single index op");
        }
        return lst[0];
    }

    public String[] convertFromWildcards(String[] aliasesOrIndices, boolean wildcardOnlyOpen, IgnoreIndices ignoreIndices) {
        if (aliasesOrIndices == null) {
            return null;
        }
        HashSet<Object> result2 = null;
        for (int i = 0; i < aliasesOrIndices.length; ++i) {
            String aliasOrIndex = aliasesOrIndices[i];
            if (this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                if (result2 == null) continue;
                result2.add(aliasOrIndex);
                continue;
            }
            boolean add = true;
            if (aliasOrIndex.charAt(0) == '+') {
                if (i == 0) {
                    result2 = new HashSet<String>();
                }
                add = true;
                aliasOrIndex = aliasOrIndex.substring(1);
            } else if (aliasOrIndex.charAt(0) == '-') {
                if (i == 0) {
                    result2 = new HashSet<String>(Arrays.asList(wildcardOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices()));
                }
                add = false;
                aliasOrIndex = aliasOrIndex.substring(1);
            }
            if (!Regex.isSimpleMatchPattern(aliasOrIndex)) {
                if (ignoreIndices != IgnoreIndices.MISSING && !this.aliasAndIndexToIndexMap.containsKey(aliasOrIndex)) {
                    throw new IndexMissingException(new Index(aliasOrIndex));
                }
                if (result2 == null) continue;
                if (add) {
                    result2.add(aliasOrIndex);
                    continue;
                }
                result2.remove(aliasOrIndex);
                continue;
            }
            if (result2 == null) {
                result2 = new HashSet();
                result2.addAll(Arrays.asList(aliasesOrIndices).subList(0, i));
            }
            String[] indices = wildcardOnlyOpen ? this.concreteAllOpenIndices() : this.concreteAllIndices();
            boolean found = false;
            for (String index : indices) {
                if (!Regex.simpleMatch(aliasOrIndex, index)) continue;
                found = true;
                if (add) {
                    result2.add(index);
                    continue;
                }
                result2.remove(index);
            }
            for (ObjectCursor cursor : this.aliases.keys()) {
                String alias = (String)cursor.value;
                if (!Regex.simpleMatch(aliasOrIndex, alias)) continue;
                found = true;
                if (add) {
                    result2.add(alias);
                    continue;
                }
                result2.remove(alias);
            }
            if (found || ignoreIndices == IgnoreIndices.MISSING) continue;
            throw new IndexMissingException(new Index(aliasOrIndex));
        }
        if (result2 == null) {
            return aliasesOrIndices;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasConcreteIndex(String index) {
        return this.aliasAndIndexToIndexMap.containsKey(index);
    }

    public IndexMetaData index(String index) {
        return this.indices.get(index);
    }

    public ImmutableOpenMap<String, IndexMetaData> indices() {
        return this.indices;
    }

    public ImmutableOpenMap<String, IndexMetaData> getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> templates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, IndexTemplateMetaData> getTemplates() {
        return this.templates;
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public int getNumberOfShards() {
        return this.numberOfShards();
    }

    public String[] filteringAliases(String index, String ... indicesOrAliases) {
        if (this.isAllIndices(indicesOrAliases = this.convertFromWildcards(indicesOrAliases, true, IgnoreIndices.MISSING))) {
            return null;
        }
        if (indicesOrAliases.length == 1) {
            boolean filteringRequired;
            String alias = indicesOrAliases[0];
            IndexMetaData indexMetaData = this.indices.get(index);
            if (indexMetaData == null) {
                throw new IndexMissingException(new Index(index));
            }
            AliasMetaData aliasMetaData = indexMetaData.aliases().get(alias);
            boolean bl = filteringRequired = aliasMetaData != null && aliasMetaData.filteringRequired();
            if (!filteringRequired) {
                return null;
            }
            return new String[]{alias};
        }
        ArrayList<String> filteringAliases = null;
        for (String alias : indicesOrAliases) {
            if (alias.equals(index)) {
                return null;
            }
            IndexMetaData indexMetaData = this.indices.get(index);
            if (indexMetaData == null) {
                throw new IndexMissingException(new Index(index));
            }
            AliasMetaData aliasMetaData = indexMetaData.aliases().get(alias);
            if (aliasMetaData == null) continue;
            boolean filteringRequired = aliasMetaData.filteringRequired();
            if (filteringRequired) {
                if (filteringAliases == null) {
                    filteringAliases = Lists.newArrayList();
                }
                filteringAliases.add(alias);
                continue;
            }
            return null;
        }
        if (filteringAliases == null) {
            return null;
        }
        return filteringAliases.toArray(new String[filteringAliases.size()]);
    }

    private boolean isAllIndices(String[] aliasesOrIndices) {
        return aliasesOrIndices == null || aliasesOrIndices.length == 0 || aliasesOrIndices.length == 1 && "_all".equals(aliasesOrIndices[0]);
    }

    @Override
    public UnmodifiableIterator<IndexMetaData> iterator() {
        return this.indices.valuesIt();
    }

    public static boolean isGlobalStateEquals(MetaData metaData1, MetaData metaData2) {
        if (!metaData1.persistentSettings.equals(metaData2.persistentSettings)) {
            return false;
        }
        return metaData1.templates.equals(metaData2.templates());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(MetaData metaData) {
        return new Builder(metaData);
    }

    public static class Builder {
        private String uuid;
        private long version;
        private Settings transientSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private Settings persistentSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, IndexMetaData> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetaData> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder() {
            this.uuid = "_na_";
            this.indices = ImmutableOpenMap.builder();
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(MetaData metaData) {
            this.uuid = metaData.uuid;
            this.transientSettings = metaData.transientSettings;
            this.persistentSettings = metaData.persistentSettings;
            this.version = metaData.version;
            this.indices = ImmutableOpenMap.builder(metaData.indices);
            this.templates = ImmutableOpenMap.builder(metaData.templates);
            this.customs = ImmutableOpenMap.builder(metaData.customs);
        }

        public Builder put(IndexMetaData.Builder indexMetaDataBuilder) {
            indexMetaDataBuilder.version(indexMetaDataBuilder.version() + 1L);
            IndexMetaData indexMetaData = indexMetaDataBuilder.build();
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public Builder put(IndexMetaData indexMetaData, boolean incrementVersion) {
            if (this.indices.get(indexMetaData.index()) == indexMetaData) {
                return this;
            }
            if (incrementVersion) {
                indexMetaData = IndexMetaData.builder(indexMetaData).version(indexMetaData.version() + 1L).build();
            }
            this.indices.put(indexMetaData.index(), indexMetaData);
            return this;
        }

        public IndexMetaData get(String index) {
            return this.indices.get(index);
        }

        public Builder remove(String index) {
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.indices.clear();
            return this;
        }

        public Builder put(IndexTemplateMetaData.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetaData template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, custom);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.builder(indexMetaData).settings(ImmutableSettings.settingsBuilder().put(indexMetaData.settings()).put(settings)));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keys().toArray(String.class);
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = this.indices.get(index);
                if (indexMetaData == null) {
                    throw new IndexMissingException(new Index(index));
                }
                this.put(IndexMetaData.builder(indexMetaData).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder generateUuidIfNeeded() {
            if (this.uuid.equals("_na_")) {
                this.uuid = Strings.randomBase64UUID();
            }
            return this;
        }

        public MetaData build() {
            return new MetaData(this.uuid, this.version, this.transientSettings, this.persistentSettings, this.indices.build(), this.templates.build(), this.customs.build());
        }

        public static String toXContent(MetaData metaData) throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            Builder.toXContent(metaData, builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            return builder.string();
        }

        public static void toXContent(MetaData metaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("meta-data");
            builder.field("version", metaData.version());
            builder.field("uuid", metaData.uuid);
            if (!metaData.persistentSettings().getAsMap().isEmpty()) {
                builder.startObject("settings");
                for (Map.Entry entry2 : metaData.persistentSettings().getAsMap().entrySet()) {
                    builder.field((String)entry2.getKey(), (String)entry2.getValue());
                }
                builder.endObject();
            }
            builder.startObject("templates");
            for (ObjectCursor objectCursor : metaData.templates().values()) {
                IndexTemplateMetaData.Builder.toXContent((IndexTemplateMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            if (!metaData.indices().isEmpty()) {
                builder.startObject("indices");
                for (IndexMetaData indexMetaData : metaData) {
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, params);
                }
                builder.endObject();
            }
            for (ObjectObjectCursor objectObjectCursor : metaData.customs()) {
                builder.startObject((String)objectObjectCursor.key);
                MetaData.lookupFactorySafe((String)objectObjectCursor.key).toXContent((Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
            builder.endObject();
        }

        public static MetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token2 = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token2 = parser.nextToken();
                if (token2 == XContentParser.Token.START_OBJECT) {
                    token2 = parser.nextToken();
                    token2 = parser.nextToken();
                }
                currentFieldName = parser.currentName();
                if (token2 == null) {
                    return builder.build();
                }
            }
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())).build());
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetaData.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    Custom.Factory factory = MetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (Custom)factory.fromXContent(parser));
                    continue;
                }
                if (!token2.isValue()) continue;
                if ("version".equals(currentFieldName)) {
                    builder.version = parser.longValue();
                    continue;
                }
                if (!"uuid".equals(currentFieldName)) continue;
                builder.uuid = parser.text();
            }
            return builder.build();
        }

        public static MetaData readFrom(StreamInput in) throws IOException {
            int i;
            Builder builder = new Builder();
            builder.version = in.readLong();
            if (in.getVersion().after(Version.V_0_90_7)) {
                builder.uuid = in.readString();
            }
            builder.transientSettings(ImmutableSettings.readSettingsFromStream(in));
            builder.persistentSettings(ImmutableSettings.readSettingsFromStream(in));
            int size2 = in.readVInt();
            for (i = 0; i < size2; ++i) {
                builder.put(IndexMetaData.Builder.readFrom(in), false);
            }
            size2 = in.readVInt();
            for (i = 0; i < size2; ++i) {
                builder.put(IndexTemplateMetaData.Builder.readFrom(in));
            }
            int customSize = in.readVInt();
            for (int i2 = 0; i2 < customSize; ++i2) {
                String type = in.readString();
                Object customIndexMetaData = MetaData.lookupFactorySafe(type).readFrom(in);
                builder.putCustom(type, (Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(MetaData metaData, StreamOutput out) throws IOException {
            out.writeLong(metaData.version);
            if (out.getVersion().after(Version.V_0_90_7)) {
                out.writeString(metaData.uuid);
            }
            ImmutableSettings.writeSettingsToStream(metaData.transientSettings(), out);
            ImmutableSettings.writeSettingsToStream(metaData.persistentSettings(), out);
            out.writeVInt(metaData.indices.size());
            for (IndexMetaData indexMetaData : metaData) {
                IndexMetaData.Builder.writeTo(indexMetaData, out);
            }
            out.writeVInt(metaData.templates.size());
            for (ObjectCursor objectCursor : metaData.templates.values()) {
                IndexTemplateMetaData.Builder.writeTo((IndexTemplateMetaData)objectCursor.value, out);
            }
            out.writeVInt(metaData.customs().size());
            for (ObjectObjectCursor objectObjectCursor : metaData.customs()) {
                out.writeString((String)objectObjectCursor.key);
                MetaData.lookupFactorySafe((String)objectObjectCursor.key).writeTo((Custom)objectObjectCursor.value, out);
            }
        }
    }

    public static interface Custom {

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public T fromXContent(XContentParser var1) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3);
        }
    }
}

