/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.hppc.ObjectObjectAssociativeContainer;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.SettingsLoader;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class IndexMetaData {
    public static Map<String, Custom.Factory> customFactories = new HashMap<String, Custom.Factory>();
    public static final ClusterBlock INDEX_READ_ONLY_BLOCK;
    public static final ClusterBlock INDEX_READ_BLOCK;
    public static final ClusterBlock INDEX_WRITE_BLOCK;
    public static final ClusterBlock INDEX_METADATA_BLOCK;
    public static final String SETTING_NUMBER_OF_SHARDS = "index.number_of_shards";
    public static final String SETTING_NUMBER_OF_REPLICAS = "index.number_of_replicas";
    public static final String SETTING_AUTO_EXPAND_REPLICAS = "index.auto_expand_replicas";
    public static final String SETTING_READ_ONLY = "index.blocks.read_only";
    public static final String SETTING_BLOCKS_READ = "index.blocks.read";
    public static final String SETTING_BLOCKS_WRITE = "index.blocks.write";
    public static final String SETTING_BLOCKS_METADATA = "index.blocks.metadata";
    public static final String SETTING_VERSION_CREATED = "index.version.created";
    public static final String SETTING_UUID = "index.uuid";
    public static final String INDEX_UUID_NA_VALUE = "_na_";
    private final String index;
    private final long version;
    private final State state;
    private final ImmutableOpenMap<String, AliasMetaData> aliases;
    private final Settings settings;
    private final ImmutableOpenMap<String, MappingMetaData> mappings;
    private final ImmutableOpenMap<String, Custom> customs;
    private final transient int totalNumberOfShards;
    private final DiscoveryNodeFilters requireFilters;
    private final DiscoveryNodeFilters includeFilters;
    private final DiscoveryNodeFilters excludeFilters;

    public static void registerFactory(String type, Custom.Factory factory) {
        customFactories.put(type, factory);
    }

    @Nullable
    public static <T extends Custom> Custom.Factory<T> lookupFactory(String type) {
        return customFactories.get(type);
    }

    public static <T extends Custom> Custom.Factory<T> lookupFactorySafe(String type) throws ElasticSearchIllegalArgumentException {
        Custom.Factory factory = customFactories.get(type);
        if (factory == null) {
            throw new ElasticSearchIllegalArgumentException("No custom index metadata factoy registered for type [" + type + "]");
        }
        return factory;
    }

    private IndexMetaData(String index, long version, State state, Settings settings, ImmutableOpenMap<String, MappingMetaData> mappings, ImmutableOpenMap<String, AliasMetaData> aliases, ImmutableOpenMap<String, Custom> customs) {
        Preconditions.checkArgument(settings.getAsInt(SETTING_NUMBER_OF_SHARDS, (Integer)-1) != -1, "must specify numberOfShards for index [" + index + "]");
        Preconditions.checkArgument(settings.getAsInt(SETTING_NUMBER_OF_REPLICAS, (Integer)-1) != -1, "must specify numberOfReplicas for index [" + index + "]");
        this.index = index;
        this.version = version;
        this.state = state;
        this.settings = settings;
        this.mappings = mappings;
        this.customs = customs;
        this.totalNumberOfShards = this.numberOfShards() * (this.numberOfReplicas() + 1);
        this.aliases = aliases;
        ImmutableMap<String, String> requireMap = settings.getByPrefix("index.routing.allocation.require.").getAsMap();
        this.requireFilters = requireMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.AND, requireMap);
        ImmutableMap<String, String> includeMap = settings.getByPrefix("index.routing.allocation.include.").getAsMap();
        this.includeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, includeMap);
        ImmutableMap<String, String> excludeMap = settings.getByPrefix("index.routing.allocation.exclude.").getAsMap();
        this.excludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(DiscoveryNodeFilters.OpType.OR, excludeMap);
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public String uuid() {
        return this.settings.get(SETTING_UUID, INDEX_UUID_NA_VALUE);
    }

    public String getUUID() {
        return this.uuid();
    }

    public boolean isSameUUID(String otherUUID) {
        assert (otherUUID != null);
        assert (this.uuid() != null);
        if (INDEX_UUID_NA_VALUE.equals(otherUUID) || INDEX_UUID_NA_VALUE.equals(this.uuid())) {
            return true;
        }
        return otherUUID.equals(this.getUUID());
    }

    public long version() {
        return this.version;
    }

    public long getVersion() {
        return this.version;
    }

    public State state() {
        return this.state;
    }

    public State getState() {
        return this.state();
    }

    public int numberOfShards() {
        return this.settings.getAsInt(SETTING_NUMBER_OF_SHARDS, (Integer)-1);
    }

    public int getNumberOfShards() {
        return this.numberOfShards();
    }

    public int numberOfReplicas() {
        return this.settings.getAsInt(SETTING_NUMBER_OF_REPLICAS, (Integer)-1);
    }

    public int getNumberOfReplicas() {
        return this.numberOfReplicas();
    }

    public int totalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards();
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings getSettings() {
        return this.settings();
    }

    public ImmutableOpenMap<String, AliasMetaData> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, AliasMetaData> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, MappingMetaData> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, MappingMetaData> getMappings() {
        return this.mappings();
    }

    @Nullable
    public MappingMetaData mapping(String mappingType) {
        return this.mappings.get(mappingType);
    }

    @Nullable
    public MappingMetaData mappingOrDefault(String mappingType) {
        MappingMetaData mapping = this.mappings.get(mappingType);
        if (mapping != null) {
            return mapping;
        }
        return this.mappings.get("_default_");
    }

    public ImmutableOpenMap<String, Custom> customs() {
        return this.customs;
    }

    public ImmutableOpenMap<String, Custom> getCustoms() {
        return this.customs;
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    @Nullable
    public DiscoveryNodeFilters requireFilters() {
        return this.requireFilters;
    }

    @Nullable
    public DiscoveryNodeFilters includeFilters() {
        return this.includeFilters;
    }

    @Nullable
    public DiscoveryNodeFilters excludeFilters() {
        return this.excludeFilters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMetaData that = (IndexMetaData)o;
        if (!this.aliases.equals(that.aliases)) {
            return false;
        }
        if (!this.index.equals(that.index)) {
            return false;
        }
        if (!this.mappings.equals(that.mappings)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.state == that.state;
    }

    public int hashCode() {
        int result2 = this.index.hashCode();
        result2 = 31 * result2 + this.state.hashCode();
        result2 = 31 * result2 + this.aliases.hashCode();
        result2 = 31 * result2 + this.settings.hashCode();
        result2 = 31 * result2 + this.mappings.hashCode();
        return result2;
    }

    public static Builder builder(String index) {
        return new Builder(index);
    }

    public static Builder builder(IndexMetaData indexMetaData) {
        return new Builder(indexMetaData);
    }

    static {
        IndexMetaData.registerFactory("warmers", IndexWarmersMetaData.FACTORY);
        INDEX_READ_ONLY_BLOCK = new ClusterBlock(5, "index read-only (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA);
        INDEX_READ_BLOCK = new ClusterBlock(7, "index read (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.READ);
        INDEX_WRITE_BLOCK = new ClusterBlock(8, "index write (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.WRITE);
        INDEX_METADATA_BLOCK = new ClusterBlock(9, "index metadata (api)", false, false, RestStatus.FORBIDDEN, ClusterBlockLevel.METADATA);
    }

    public static class Builder {
        private String index;
        private State state = State.OPEN;
        private long version = 1L;
        private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
        private final ImmutableOpenMap.Builder<String, MappingMetaData> mappings;
        private final ImmutableOpenMap.Builder<String, AliasMetaData> aliases;
        private final ImmutableOpenMap.Builder<String, Custom> customs;

        public Builder(String index) {
            this.index = index;
            this.mappings = ImmutableOpenMap.builder();
            this.aliases = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
        }

        public Builder(IndexMetaData indexMetaData) {
            this.index = indexMetaData.index();
            this.state = indexMetaData.state;
            this.version = indexMetaData.version;
            this.settings = indexMetaData.settings();
            this.mappings = ImmutableOpenMap.builder(indexMetaData.mappings);
            this.aliases = ImmutableOpenMap.builder(indexMetaData.aliases);
            this.customs = ImmutableOpenMap.builder(indexMetaData.customs);
        }

        public String index() {
            return this.index;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder numberOfShards(int numberOfShards) {
            this.settings = ImmutableSettings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_SHARDS, numberOfShards).build();
            return this;
        }

        public int numberOfShards() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_SHARDS, (Integer)-1);
        }

        public Builder numberOfReplicas(int numberOfReplicas) {
            this.settings = ImmutableSettings.settingsBuilder().put(this.settings).put(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, numberOfReplicas).build();
            return this;
        }

        public int numberOfReplicas() {
            return this.settings.getAsInt(IndexMetaData.SETTING_NUMBER_OF_REPLICAS, (Integer)-1);
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public MappingMetaData mapping(String type) {
            return this.mappings.get(type);
        }

        public Builder removeMapping(String mappingType) {
            this.mappings.remove(mappingType);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder putMapping(String type, String source) throws IOException {
            XContentParser parser = XContentFactory.xContent(source).createParser(source);
            try {
                this.putMapping(new MappingMetaData(type, parser.mapOrdered()));
            }
            finally {
                parser.close();
            }
            return this;
        }

        public Builder putMapping(MappingMetaData mappingMd) {
            this.mappings.put(mappingMd.type(), mappingMd);
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder putAlias(AliasMetaData aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData);
            return this;
        }

        public Builder putAlias(AliasMetaData.Builder aliasMetaData) {
            this.aliases.put(aliasMetaData.alias(), aliasMetaData.build());
            return this;
        }

        public Builder removerAlias(String alias) {
            this.aliases.remove(alias);
            return this;
        }

        public Builder putCustom(String type, Custom customIndexMetaData) {
            this.customs.put(type, customIndexMetaData);
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public long version() {
            return this.version;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public IndexMetaData build() {
            ImmutableOpenMap.Builder<String, AliasMetaData> tmpAliases = this.aliases;
            Settings tmpSettings = this.settings;
            String[] legacyAliases = this.settings.getAsArray("index.aliases");
            if (legacyAliases.length > 0) {
                void var6_8;
                tmpAliases = ImmutableOpenMap.builder();
                String[] arr$ = legacyAliases;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_8 < len$) {
                    String alias = arr$[var6_8];
                    AliasMetaData aliasMd = AliasMetaData.newAliasMetaDataBuilder(alias).build();
                    tmpAliases.put(alias, aliasMd);
                    ++var6_8;
                }
                tmpAliases.putAll((ObjectObjectAssociativeContainer<String, AliasMetaData>)this.aliases);
                tmpSettings = ImmutableSettings.settingsBuilder().put(this.settings).putArray("index.aliases", new String[0]).build();
            }
            if (this.mappings.containsKey("_default_")) {
                MappingMetaData defaultMapping = this.mappings.get("_default_");
                for (ObjectCursor<MappingMetaData> objectCursor : this.mappings.values()) {
                    ((MappingMetaData)objectCursor.value).updateDefaultMapping(defaultMapping);
                }
            }
            return new IndexMetaData(this.index, this.version, this.state, tmpSettings, this.mappings.build(), tmpAliases.build(), this.customs.build());
        }

        public static void toXContent(IndexMetaData indexMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
            builder.field("version", indexMetaData.version());
            builder.field("state", indexMetaData.state().toString().toLowerCase(Locale.ENGLISH));
            boolean binary = params.paramAsBoolean("binary", false);
            builder.startObject("settings");
            for (Map.Entry entry2 : indexMetaData.settings().getAsMap().entrySet()) {
                builder.field((String)entry2.getKey(), (String)entry2.getValue());
            }
            builder.endObject();
            builder.startArray("mappings");
            for (ObjectObjectCursor<String, MappingMetaData> objectObjectCursor : indexMetaData.mappings()) {
                if (binary) {
                    builder.value(((MappingMetaData)objectObjectCursor.value).source().compressed());
                    continue;
                }
                byte[] data2 = ((MappingMetaData)objectObjectCursor.value).source().uncompressed();
                XContentParser parser = XContentFactory.xContent(data2).createParser(data2);
                Map<String, Object> mapping = parser.mapOrdered();
                parser.close();
                builder.map(mapping);
            }
            builder.endArray();
            for (ObjectObjectCursor<String, Object> objectObjectCursor : indexMetaData.customs()) {
                builder.startObject((String)objectObjectCursor.key, XContentBuilder.FieldCaseConversion.NONE);
                IndexMetaData.lookupFactorySafe((String)objectObjectCursor.key).toXContent((Custom)objectObjectCursor.value, builder, params);
                builder.endObject();
            }
            builder.startObject("aliases");
            for (ObjectCursor objectCursor : indexMetaData.aliases().values()) {
                AliasMetaData.Builder.toXContent((AliasMetaData)objectCursor.value, builder, params);
            }
            builder.endObject();
            builder.endObject();
        }

        public static IndexMetaData fromXContent(XContentParser parser) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                parser.nextToken();
            }
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token2 = parser.nextToken();
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        builder.settings(ImmutableSettings.settingsBuilder().put(SettingsLoader.Helper.loadNestedFromMap(parser.mapOrdered())));
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token2 == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token2 != XContentParser.Token.START_OBJECT) continue;
                            String mappingType = currentFieldName;
                            Map<String, Object> mappingSource = MapBuilder.newMapBuilder().put(mappingType, parser.mapOrdered()).map();
                            builder.putMapping(new MappingMetaData(mappingType, mappingSource));
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetaData.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    Custom.Factory factory = IndexMetaData.lookupFactory(currentFieldName);
                    if (factory == null) {
                        parser.skipChildren();
                        continue;
                    }
                    builder.putCustom(factory.type(), (Custom)factory.fromXContent(parser));
                    continue;
                }
                if (token2 == XContentParser.Token.START_ARRAY) {
                    if (!"mappings".equals(currentFieldName)) continue;
                    while ((token2 = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (token2 == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                            builder.putMapping(new MappingMetaData(new CompressedString(parser.binaryValue())));
                            continue;
                        }
                        Map<String, Object> mapping = parser.mapOrdered();
                        if (mapping.size() != 1) continue;
                        String mappingType = mapping.keySet().iterator().next();
                        builder.putMapping(new MappingMetaData(mappingType, mapping));
                    }
                    continue;
                }
                if (!token2.isValue()) continue;
                if ("state".equals(currentFieldName)) {
                    builder.state(State.fromString(parser.text()));
                    continue;
                }
                if (!"version".equals(currentFieldName)) continue;
                builder.version(parser.longValue());
            }
            return builder.build();
        }

        public static IndexMetaData readFrom(StreamInput in) throws IOException {
            Builder builder = new Builder(in.readString());
            builder.version(in.readLong());
            builder.state(State.fromId(in.readByte()));
            builder.settings(ImmutableSettings.readSettingsFromStream(in));
            int mappingsSize = in.readVInt();
            for (int i = 0; i < mappingsSize; ++i) {
                MappingMetaData mappingMd = MappingMetaData.readFrom(in);
                builder.putMapping(mappingMd);
            }
            int aliasesSize = in.readVInt();
            for (int i = 0; i < aliasesSize; ++i) {
                AliasMetaData aliasMd = AliasMetaData.Builder.readFrom(in);
                builder.putAlias(aliasMd);
            }
            int customSize = in.readVInt();
            for (int i = 0; i < customSize; ++i) {
                String type = in.readString();
                Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type).readFrom(in);
                builder.putCustom(type, (Custom)customIndexMetaData);
            }
            return builder.build();
        }

        public static void writeTo(IndexMetaData indexMetaData, StreamOutput out) throws IOException {
            out.writeString(indexMetaData.index());
            out.writeLong(indexMetaData.version());
            out.writeByte(indexMetaData.state().id());
            ImmutableSettings.writeSettingsToStream(indexMetaData.settings(), out);
            out.writeVInt(indexMetaData.mappings().size());
            for (ObjectCursor<MappingMetaData> objectCursor : indexMetaData.mappings().values()) {
                MappingMetaData.writeTo((MappingMetaData)objectCursor.value, out);
            }
            out.writeVInt(indexMetaData.aliases().size());
            for (ObjectCursor<Object> objectCursor : indexMetaData.aliases().values()) {
                AliasMetaData.Builder.writeTo((AliasMetaData)objectCursor.value, out);
            }
            out.writeVInt(indexMetaData.customs().size());
            for (ObjectObjectCursor objectObjectCursor : indexMetaData.customs()) {
                out.writeString((String)objectObjectCursor.key);
                IndexMetaData.lookupFactorySafe((String)objectObjectCursor.key).writeTo((Custom)objectObjectCursor.value, out);
            }
        }
    }

    public static enum State {
        OPEN(0),
        CLOSE(1);

        private final byte id;

        private State(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static State fromId(byte id) {
            if (id == 0) {
                return OPEN;
            }
            if (id == 1) {
                return CLOSE;
            }
            throw new ElasticSearchIllegalStateException("No state match for id [" + id + "]");
        }

        public static State fromString(String state) {
            if ("open".equals(state)) {
                return OPEN;
            }
            if ("close".equals(state)) {
                return CLOSE;
            }
            throw new ElasticSearchIllegalStateException("No state match for [" + state + "]");
        }
    }

    public static interface Custom {
        public String type();

        public static interface Factory<T extends Custom> {
            public String type();

            public T readFrom(StreamInput var1) throws IOException;

            public void writeTo(T var1, StreamOutput var2) throws IOException;

            public T fromMap(Map<String, Object> var1) throws IOException;

            public T fromXContent(XContentParser var1) throws IOException;

            public void toXContent(T var1, XContentBuilder var2, ToXContent.Params var3) throws IOException;

            public T merge(T var1, T var2);
        }
    }
}

