/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;

public class AliasMetaData {
    private final String alias;
    private final CompressedString filter;
    private final String indexRouting;
    private final String searchRouting;
    private final Set<String> searchRoutingValues;

    private AliasMetaData(String alias, CompressedString filter2, String indexRouting, String searchRouting) {
        this.alias = alias;
        this.filter = filter2;
        this.indexRouting = indexRouting;
        this.searchRouting = searchRouting;
        this.searchRoutingValues = searchRouting != null ? Collections.unmodifiableSet(Strings.splitStringByCommaToSet(searchRouting)) : ImmutableSet.of();
    }

    public String alias() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias();
    }

    public CompressedString filter() {
        return this.filter;
    }

    public CompressedString getFilter() {
        return this.filter();
    }

    public boolean filteringRequired() {
        return this.filter != null;
    }

    public String getSearchRouting() {
        return this.searchRouting();
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public String getIndexRouting() {
        return this.indexRouting();
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Set<String> searchRoutingValues() {
        return this.searchRoutingValues;
    }

    public static Builder builder(String alias) {
        return new Builder(alias);
    }

    public static Builder newAliasMetaDataBuilder(String alias) {
        return new Builder(alias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasMetaData that = (AliasMetaData)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.indexRouting != null ? !this.indexRouting.equals(that.indexRouting) : that.indexRouting != null) {
            return false;
        }
        return !(this.searchRouting != null ? !this.searchRouting.equals(that.searchRouting) : that.searchRouting != null);
    }

    public int hashCode() {
        int result2 = this.alias != null ? this.alias.hashCode() : 0;
        result2 = 31 * result2 + (this.filter != null ? this.filter.hashCode() : 0);
        result2 = 31 * result2 + (this.indexRouting != null ? this.indexRouting.hashCode() : 0);
        result2 = 31 * result2 + (this.searchRouting != null ? this.searchRouting.hashCode() : 0);
        return result2;
    }

    public static class Builder {
        private String alias;
        private CompressedString filter;
        private String indexRouting;
        private String searchRouting;

        public Builder(String alias) {
            this.alias = alias;
        }

        public Builder(AliasMetaData aliasMetaData) {
            this(aliasMetaData.alias());
            this.filter = aliasMetaData.filter();
            this.indexRouting = aliasMetaData.indexRouting();
            this.searchRouting = aliasMetaData.searchRouting();
        }

        public String alias() {
            return this.alias;
        }

        public Builder filter(CompressedString filter2) {
            this.filter = filter2;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder filter(String filter2) {
            if (!Strings.hasLength(filter2)) {
                this.filter = null;
                return this;
            }
            try {
                XContentParser parser = XContentFactory.xContent(filter2).createParser(filter2);
                try {
                    this.filter(parser.mapOrdered());
                }
                finally {
                    parser.close();
                }
                return this;
            }
            catch (IOException e) {
                throw new ElasticSearchGenerationException("Failed to generate [" + filter2 + "]", e);
            }
        }

        public Builder filter(Map<String, Object> filter2) {
            if (filter2 == null || filter2.isEmpty()) {
                this.filter = null;
                return this;
            }
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder().map(filter2);
                this.filter = new CompressedString(builder.bytes());
                return this;
            }
            catch (IOException e) {
                throw new ElasticSearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public Builder filter(XContentBuilder filterBuilder) {
            try {
                return this.filter(filterBuilder.string());
            }
            catch (IOException e) {
                throw new ElasticSearchGenerationException("Failed to build json for alias request", e);
            }
        }

        public Builder routing(String routing) {
            this.indexRouting = routing;
            this.searchRouting = routing;
            return this;
        }

        public Builder indexRouting(String indexRouting) {
            this.indexRouting = indexRouting;
            return this;
        }

        public Builder searchRouting(String searchRouting) {
            this.searchRouting = searchRouting;
            return this;
        }

        public AliasMetaData build() {
            return new AliasMetaData(this.alias, this.filter, this.indexRouting, this.searchRouting);
        }

        public static void toXContent(AliasMetaData aliasMetaData, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(aliasMetaData.alias(), XContentBuilder.FieldCaseConversion.NONE);
            boolean binary = params.paramAsBoolean("binary", false);
            if (aliasMetaData.filter() != null) {
                if (binary) {
                    builder.field("filter", aliasMetaData.filter.compressed());
                } else {
                    byte[] data2 = aliasMetaData.filter().uncompressed();
                    XContentParser parser = XContentFactory.xContent(data2).createParser(data2);
                    Map<String, Object> filter2 = parser.mapOrdered();
                    parser.close();
                    builder.field("filter", filter2);
                }
            }
            if (aliasMetaData.indexRouting() != null) {
                builder.field("index_routing", aliasMetaData.indexRouting());
            }
            if (aliasMetaData.searchRouting() != null) {
                builder.field("search_routing", aliasMetaData.searchRouting());
            }
            builder.endObject();
        }

        public static AliasMetaData fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder(parser.currentName());
            String currentFieldName = null;
            XContentParser.Token token2 = parser.nextToken();
            if (token2 == null) {
                return builder.build();
            }
            while ((token2 = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token2 == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token2 == XContentParser.Token.START_OBJECT) {
                    if (!"filter".equals(currentFieldName)) continue;
                    Map<String, Object> filter2 = parser.mapOrdered();
                    builder.filter(filter2);
                    continue;
                }
                if (token2 == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                    if (!"filter".equals(currentFieldName)) continue;
                    builder.filter(new CompressedString(parser.binaryValue()));
                    continue;
                }
                if (token2 != XContentParser.Token.VALUE_STRING) continue;
                if ("routing".equals(currentFieldName)) {
                    builder.routing(parser.text());
                    continue;
                }
                if ("index_routing".equals(currentFieldName) || "indexRouting".equals(currentFieldName)) {
                    builder.indexRouting(parser.text());
                    continue;
                }
                if (!"search_routing".equals(currentFieldName) && !"searchRouting".equals(currentFieldName)) continue;
                builder.searchRouting(parser.text());
            }
            return builder.build();
        }

        public static void writeTo(AliasMetaData aliasMetaData, StreamOutput out) throws IOException {
            out.writeString(aliasMetaData.alias());
            if (aliasMetaData.filter() != null) {
                out.writeBoolean(true);
                aliasMetaData.filter.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
            if (aliasMetaData.indexRouting() != null) {
                out.writeBoolean(true);
                out.writeString(aliasMetaData.indexRouting());
            } else {
                out.writeBoolean(false);
            }
            if (aliasMetaData.searchRouting() != null) {
                out.writeBoolean(true);
                out.writeString(aliasMetaData.searchRouting());
            } else {
                out.writeBoolean(false);
            }
        }

        public static AliasMetaData readFrom(StreamInput in) throws IOException {
            String alias = in.readString();
            CompressedString filter2 = null;
            if (in.readBoolean()) {
                filter2 = CompressedString.readCompressedString(in);
            }
            String indexRouting = null;
            if (in.readBoolean()) {
                indexRouting = in.readString();
            }
            String searchRouting = null;
            if (in.readBoolean()) {
                searchRouting = in.readString();
            }
            return new AliasMetaData(alias, filter2, indexRouting, searchRouting);
        }
    }
}

