/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.MetaDataMappingService;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class NodeMappingRefreshAction
extends AbstractComponent {
    private final TransportService transportService;
    private final MetaDataMappingService metaDataMappingService;

    @Inject
    public NodeMappingRefreshAction(Settings settings, TransportService transportService, MetaDataMappingService metaDataMappingService) {
        super(settings);
        this.transportService = transportService;
        this.metaDataMappingService = metaDataMappingService;
        transportService.registerHandler("cluster/nodeMappingRefresh", new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(ClusterState state, NodeMappingRefreshRequest request) throws ElasticSearchException {
        DiscoveryNodes nodes = state.nodes();
        if (nodes.localNodeMaster()) {
            this.innerMappingRefresh(request);
        } else {
            this.transportService.sendRequest(state.nodes().masterNode(), "cluster/nodeMappingRefresh", request, EmptyTransportResponseHandler.INSTANCE_SAME);
        }
    }

    private void innerMappingRefresh(NodeMappingRefreshRequest request) {
        this.metaDataMappingService.refreshMapping(request.index(), request.indexUUID(), request.types());
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest {
        private String index;
        private String indexUUID = "_na_";
        private String[] types;
        private String nodeId;

        NodeMappingRefreshRequest() {
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String[] types, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.types = types;
            this.nodeId = nodeId;
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String[] types() {
            return this.types;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeStringArray(this.types);
            out.writeString(this.nodeId);
            if (out.getVersion().onOrAfter(Version.V_0_90_6)) {
                out.writeString(this.indexUUID);
            }
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.index = in.readString();
            this.types = in.readStringArray();
            this.nodeId = in.readString();
            if (in.getVersion().onOrAfter(Version.V_0_90_6)) {
                this.indexUUID = in.readString();
            }
        }
    }

    private class NodeMappingRefreshTransportHandler
    extends BaseTransportRequestHandler<NodeMappingRefreshRequest> {
        static final String ACTION = "cluster/nodeMappingRefresh";

        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public NodeMappingRefreshRequest newInstance() {
            return new NodeMappingRefreshRequest();
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel) throws Exception {
            NodeMappingRefreshAction.this.innerMappingRefresh(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }
}

