/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.admin.indices.IndicesAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.support.AbstractIndicesAdminClient;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeIndicesAdminClient
extends AbstractIndicesAdminClient
implements IndicesAdminClient {
    private final ThreadPool threadPool;
    private final ImmutableMap<IndicesAction, TransportAction> actions;

    @Inject
    public NodeIndicesAdminClient(Settings settings, ThreadPool threadPool, Map<GenericAction, TransportAction> actions) {
        this.threadPool = threadPool;
        MapBuilder<IndicesAction, TransportAction> actionsBuilder = new MapBuilder<IndicesAction, TransportAction>();
        for (Map.Entry<GenericAction, TransportAction> entry2 : actions.entrySet()) {
            if (!(entry2.getKey() instanceof IndicesAction)) continue;
            actionsBuilder.put((IndicesAction)entry2.getKey(), entry2.getValue());
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> ActionFuture<Response> execute(IndicesAction<Request, Response, RequestBuilder> action, Request request) {
        TransportAction transportAction = this.actions.get(action);
        return transportAction.execute(request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(IndicesAction<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        TransportAction transportAction = this.actions.get(action);
        transportAction.execute(request, listener);
    }
}

