/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.client.node.NodeAdminClient;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeClient
extends AbstractClient
implements InternalClient {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final NodeAdminClient admin;
    private final ImmutableMap<Action, TransportAction> actions;

    @Inject
    public NodeClient(Settings settings, ThreadPool threadPool, NodeAdminClient admin, Map<GenericAction, TransportAction> actions) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.admin = admin;
        MapBuilder<Action, TransportAction> actionsBuilder = new MapBuilder<Action, TransportAction>();
        for (Map.Entry<GenericAction, TransportAction> entry2 : actions.entrySet()) {
            if (!(entry2.getKey() instanceof Action)) continue;
            actionsBuilder.put((Action)entry2.getKey(), entry2.getValue());
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public Settings settings() {
        return this.settings;
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public void close() {
    }

    @Override
    public AdminClient admin() {
        return this.admin;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder> action, Request request) {
        TransportAction transportAction = this.actions.get(action);
        return transportAction.execute(request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        TransportAction transportAction = this.actions.get(action);
        transportAction.execute(request, listener);
    }
}

