/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cache.recycler;

import java.util.Locale;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.DoubleIntOpenHashMap;
import org.elasticsearch.common.hppc.DoubleObjectOpenHashMap;
import org.elasticsearch.common.hppc.FloatIntOpenHashMap;
import org.elasticsearch.common.hppc.IntIntOpenHashMap;
import org.elasticsearch.common.hppc.IntObjectOpenHashMap;
import org.elasticsearch.common.hppc.LongIntOpenHashMap;
import org.elasticsearch.common.hppc.LongLongOpenHashMap;
import org.elasticsearch.common.hppc.LongObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectFloatOpenHashMap;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.ObjectOpenHashSet;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.recycler.NoneRecycler;
import org.elasticsearch.common.recycler.QueueRecycler;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.recycler.SoftThreadLocalRecycler;
import org.elasticsearch.common.recycler.ThreadLocalRecycler;
import org.elasticsearch.common.settings.Settings;

public class CacheRecycler
extends AbstractComponent {
    public final Recycler<ObjectObjectOpenHashMap> hashMap;
    public final Recycler<ObjectOpenHashSet> hashSet;
    public final Recycler<DoubleObjectOpenHashMap> doubleObjectMap;
    public final Recycler<LongObjectOpenHashMap> longObjectMap;
    public final Recycler<LongLongOpenHashMap> longLongMap;
    public final Recycler<IntIntOpenHashMap> intIntMap;
    public final Recycler<FloatIntOpenHashMap> floatIntMap;
    public final Recycler<DoubleIntOpenHashMap> doubleIntMap;
    public final Recycler<LongIntOpenHashMap> longIntMap;
    public final Recycler<ObjectIntOpenHashMap> objectIntMap;
    public final Recycler<IntObjectOpenHashMap> intObjectMap;
    public final Recycler<ObjectFloatOpenHashMap> objectFloatMap;

    public void close() {
        this.hashMap.close();
        this.hashSet.close();
        this.doubleObjectMap.close();
        this.longObjectMap.close();
        this.longLongMap.close();
        this.intIntMap.close();
        this.floatIntMap.close();
        this.doubleIntMap.close();
        this.longIntMap.close();
        this.objectIntMap.close();
        this.intObjectMap.close();
        this.objectFloatMap.close();
    }

    @Inject
    public CacheRecycler(Settings settings) {
        super(settings);
        String type = settings.get("type", Type.SOFT_THREAD_LOCAL.name());
        int limit = settings.getAsInt("limit", (Integer)10);
        int smartSize = settings.getAsInt("smart_size", (Integer)1024);
        this.hashMap = this.build(type, limit, smartSize, new Recycler.C<ObjectObjectOpenHashMap>(){

            @Override
            public ObjectObjectOpenHashMap newInstance(int sizing) {
                return new ObjectObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(ObjectObjectOpenHashMap value2) {
                value2.clear();
            }
        });
        this.hashSet = this.build(type, limit, smartSize, new Recycler.C<ObjectOpenHashSet>(){

            @Override
            public ObjectOpenHashSet newInstance(int sizing) {
                return new ObjectOpenHashSet(CacheRecycler.size(sizing), 0.5f);
            }

            @Override
            public void clear(ObjectOpenHashSet value2) {
                value2.clear();
            }
        });
        this.doubleObjectMap = this.build(type, limit, smartSize, new Recycler.C<DoubleObjectOpenHashMap>(){

            @Override
            public DoubleObjectOpenHashMap newInstance(int sizing) {
                return new DoubleObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(DoubleObjectOpenHashMap value2) {
                value2.clear();
            }
        });
        this.longObjectMap = this.build(type, limit, smartSize, new Recycler.C<LongObjectOpenHashMap>(){

            @Override
            public LongObjectOpenHashMap newInstance(int sizing) {
                return new LongObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(LongObjectOpenHashMap value2) {
                value2.clear();
            }
        });
        this.longLongMap = this.build(type, limit, smartSize, new Recycler.C<LongLongOpenHashMap>(){

            @Override
            public LongLongOpenHashMap newInstance(int sizing) {
                return new LongLongOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(LongLongOpenHashMap value2) {
                value2.clear();
            }
        });
        this.intIntMap = this.build(type, limit, smartSize, new Recycler.C<IntIntOpenHashMap>(){

            @Override
            public IntIntOpenHashMap newInstance(int sizing) {
                return new IntIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(IntIntOpenHashMap value2) {
                value2.clear();
            }
        });
        this.floatIntMap = this.build(type, limit, smartSize, new Recycler.C<FloatIntOpenHashMap>(){

            @Override
            public FloatIntOpenHashMap newInstance(int sizing) {
                return new FloatIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(FloatIntOpenHashMap value2) {
                value2.clear();
            }
        });
        this.doubleIntMap = this.build(type, limit, smartSize, new Recycler.C<DoubleIntOpenHashMap>(){

            @Override
            public DoubleIntOpenHashMap newInstance(int sizing) {
                return new DoubleIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(DoubleIntOpenHashMap value2) {
                value2.clear();
            }
        });
        this.longIntMap = this.build(type, limit, smartSize, new Recycler.C<LongIntOpenHashMap>(){

            @Override
            public LongIntOpenHashMap newInstance(int sizing) {
                return new LongIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(LongIntOpenHashMap value2) {
                value2.clear();
            }
        });
        this.objectIntMap = this.build(type, limit, smartSize, new Recycler.C<ObjectIntOpenHashMap>(){

            @Override
            public ObjectIntOpenHashMap newInstance(int sizing) {
                return new ObjectIntOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(ObjectIntOpenHashMap value2) {
                value2.clear();
            }
        });
        this.intObjectMap = this.build(type, limit, smartSize, new Recycler.C<IntObjectOpenHashMap>(){

            @Override
            public IntObjectOpenHashMap newInstance(int sizing) {
                return new IntObjectOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(IntObjectOpenHashMap value2) {
                value2.clear();
            }
        });
        this.objectFloatMap = this.build(type, limit, smartSize, new Recycler.C<ObjectFloatOpenHashMap>(){

            @Override
            public ObjectFloatOpenHashMap newInstance(int sizing) {
                return new ObjectFloatOpenHashMap(CacheRecycler.size(sizing));
            }

            @Override
            public void clear(ObjectFloatOpenHashMap value2) {
                value2.clear();
            }
        });
    }

    public <K, V> Recycler.V<ObjectObjectOpenHashMap<K, V>> hashMap(int sizing) {
        return this.hashMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectOpenHashSet<T>> hashSet(int sizing) {
        return this.hashSet.obtain(sizing);
    }

    public <T> Recycler.V<DoubleObjectOpenHashMap<T>> doubleObjectMap(int sizing) {
        return this.doubleObjectMap.obtain(sizing);
    }

    public <T> Recycler.V<LongObjectOpenHashMap<T>> longObjectMap(int sizing) {
        return this.longObjectMap.obtain(sizing);
    }

    public Recycler.V<LongLongOpenHashMap> longLongMap(int sizing) {
        return this.longLongMap.obtain(sizing);
    }

    public Recycler.V<IntIntOpenHashMap> intIntMap(int sizing) {
        return this.intIntMap.obtain(sizing);
    }

    public Recycler.V<FloatIntOpenHashMap> floatIntMap(int sizing) {
        return this.floatIntMap.obtain(sizing);
    }

    public Recycler.V<DoubleIntOpenHashMap> doubleIntMap(int sizing) {
        return this.doubleIntMap.obtain(sizing);
    }

    public Recycler.V<LongIntOpenHashMap> longIntMap(int sizing) {
        return this.longIntMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectIntOpenHashMap<T>> objectIntMap(int sizing) {
        return this.objectIntMap.obtain(sizing);
    }

    public <T> Recycler.V<IntObjectOpenHashMap<T>> intObjectMap(int sizing) {
        return this.intObjectMap.obtain(sizing);
    }

    public <T> Recycler.V<ObjectFloatOpenHashMap<T>> objectFloatMap(int sizing) {
        return this.objectFloatMap.obtain(sizing);
    }

    static int size(int sizing) {
        return sizing > 0 ? sizing : 256;
    }

    private <T> Recycler<T> build(String type, int limit, int smartSize, Recycler.C<T> c) {
        Recycler recycler;
        try {
            Type t = type == null ? Type.SOFT_THREAD_LOCAL : Type.valueOf(type.toUpperCase(Locale.ROOT));
            switch (t) {
                case SOFT_THREAD_LOCAL: {
                    recycler = new SoftThreadLocalRecycler<T>(c, limit);
                    break;
                }
                case THREAD_LOCAL: {
                    recycler = new ThreadLocalRecycler<T>(c, limit);
                    break;
                }
                case QUEUE: {
                    recycler = new QueueRecycler<T>(c);
                    break;
                }
                case NONE: {
                    recycler = new NoneRecycler<T>(c);
                    break;
                }
                default: {
                    throw new ElasticSearchIllegalArgumentException("no type support [" + type + "] for recycler");
                }
            }
            if (smartSize > 0) {
                recycler = new Recycler.Sizing<T>(recycler, smartSize);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ElasticSearchIllegalArgumentException("no type support [" + type + "] for recycler");
        }
        return recycler;
    }

    public static enum Type {
        SOFT_THREAD_LOCAL,
        THREAD_LOCAL,
        QUEUE,
        NONE;

    }
}

