/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master.info;

import java.io.IOException;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class ClusterInfoRequest<T extends ClusterInfoRequest>
extends MasterNodeOperationRequest<T> {
    private String[] indices = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private IgnoreIndices ignoreIndices = IgnoreIndices.NONE;
    private boolean local = false;

    public T indices(String ... indices) {
        this.indices = indices;
        return (T)this;
    }

    public T types(String ... types) {
        this.types = types;
        return (T)this;
    }

    public T ignoreIndices(IgnoreIndices ignoreIndices) {
        this.ignoreIndices = ignoreIndices;
        return (T)this;
    }

    public T local(boolean local) {
        this.local = local;
        return (T)this;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] types() {
        return this.types;
    }

    public IgnoreIndices ignoreIndices() {
        return this.ignoreIndices;
    }

    public boolean local() {
        return this.local;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.ignoreIndices = IgnoreIndices.fromId(in.readByte());
        this.local = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        out.writeByte(this.ignoreIndices.id());
        out.writeBoolean(this.local);
    }
}

