/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportMasterNodeOperationAction<Request extends MasterNodeOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final TransportService transportService;
    protected final ClusterService clusterService;
    final String transportAction;
    final String executor;

    protected TransportMasterNodeOperationAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, threadPool);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.transportAction = this.transportAction();
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
    }

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract void masterOperation(Request var1, ClusterState var2, ActionListener<Response> var3) throws ElasticSearchException;

    protected boolean localExecute(Request request) {
        return false;
    }

    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return null;
    }

    protected void processBeforeDelegationToMaster(Request request, ClusterState state) {
    }

    @Override
    public void execute(Request request, ActionListener<Response> listener) {
        ((ActionRequest)request).listenerThreaded(true);
        super.execute(request, listener);
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        this.innerExecute(request, listener, false);
    }

    private void innerExecute(Request request, final ActionListener<Response> listener, boolean retrying) {
        ClusterState clusterState = this.clusterService.state();
        DiscoveryNodes nodes = clusterState.nodes();
        if (nodes.localNodeMaster() || this.localExecute(request)) {
            ClusterBlockException blockException = this.checkBlock(request, clusterState);
            if (blockException != null) {
                if (!blockException.retryable()) {
                    listener.onFailure(blockException);
                    return;
                }
                this.clusterService.add(((MasterNodeOperationRequest)request).masterNodeTimeout(), new TimeoutClusterStateListener((MasterNodeOperationRequest)request, listener, blockException){
                    final /* synthetic */ MasterNodeOperationRequest val$request;
                    final /* synthetic */ ActionListener val$listener;
                    final /* synthetic */ ClusterBlockException val$blockException;
                    {
                        this.val$request = masterNodeOperationRequest;
                        this.val$listener = actionListener;
                        this.val$blockException = clusterBlockException;
                    }

                    @Override
                    public void postAdded() {
                        ClusterBlockException blockException = TransportMasterNodeOperationAction.this.checkBlock(this.val$request, TransportMasterNodeOperationAction.this.clusterService.state());
                        if (blockException == null || !blockException.retryable()) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, false);
                        }
                    }

                    @Override
                    public void onClose() {
                        TransportMasterNodeOperationAction.this.clusterService.remove(this);
                        this.val$listener.onFailure(this.val$blockException);
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        TransportMasterNodeOperationAction.this.clusterService.remove(this);
                        this.val$listener.onFailure(this.val$blockException);
                    }

                    @Override
                    public void clusterChanged(ClusterChangedEvent event) {
                        ClusterBlockException blockException = TransportMasterNodeOperationAction.this.checkBlock(this.val$request, event.state());
                        if (blockException == null || !blockException.retryable()) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, false);
                        }
                    }
                });
            } else {
                try {
                    this.threadPool.executor(this.executor).execute(new Runnable((MasterNodeOperationRequest)request, listener){
                        final /* synthetic */ MasterNodeOperationRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        {
                            this.val$request = masterNodeOperationRequest;
                            this.val$listener = actionListener;
                        }

                        @Override
                        public void run() {
                            try {
                                TransportMasterNodeOperationAction.this.masterOperation(this.val$request, TransportMasterNodeOperationAction.this.clusterService.state(), this.val$listener);
                            }
                            catch (Throwable e) {
                                this.val$listener.onFailure(e);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    listener.onFailure(t);
                }
            }
        } else {
            if (nodes.masterNode() == null) {
                if (retrying) {
                    listener.onFailure(new MasterNotDiscoveredException());
                } else {
                    this.clusterService.add(((MasterNodeOperationRequest)request).masterNodeTimeout(), new TimeoutClusterStateListener((MasterNodeOperationRequest)request, listener){
                        final /* synthetic */ MasterNodeOperationRequest val$request;
                        final /* synthetic */ ActionListener val$listener;
                        {
                            this.val$request = masterNodeOperationRequest;
                            this.val$listener = actionListener;
                        }

                        @Override
                        public void postAdded() {
                            ClusterState clusterStateV2 = TransportMasterNodeOperationAction.this.clusterService.state();
                            if (clusterStateV2.nodes().masterNodeId() != null) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, true);
                            }
                        }

                        @Override
                        public void onClose() {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            this.val$listener.onFailure(new NodeClosedException(TransportMasterNodeOperationAction.this.clusterService.localNode()));
                        }

                        @Override
                        public void onTimeout(TimeValue timeout) {
                            TransportMasterNodeOperationAction.this.clusterService.remove(this);
                            this.val$listener.onFailure(new MasterNotDiscoveredException("waited for [" + timeout + "]"));
                        }

                        @Override
                        public void clusterChanged(ClusterChangedEvent event) {
                            if (event.nodesDelta().masterNodeChanged()) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                TransportMasterNodeOperationAction.this.innerExecute(this.val$request, this.val$listener, true);
                            }
                        }
                    });
                }
                return;
            }
            this.processBeforeDelegationToMaster(request, clusterState);
            this.transportService.sendRequest(nodes.masterNode(), this.transportAction, (TransportRequest)request, new BaseTransportResponseHandler<Response>((MasterNodeOperationRequest)request, clusterState){
                final /* synthetic */ MasterNodeOperationRequest val$request;
                final /* synthetic */ ClusterState val$clusterState;
                {
                    this.val$request = masterNodeOperationRequest;
                    this.val$clusterState = clusterState;
                }

                @Override
                public Response newInstance() {
                    return TransportMasterNodeOperationAction.this.newResponse();
                }

                @Override
                public void handleResponse(Response response) {
                    listener.onResponse(response);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleException(TransportException exp) {
                    if (exp.unwrapCause() instanceof ConnectTransportException) {
                        TransportMasterNodeOperationAction.this.clusterService.add(this.val$request.masterNodeTimeout(), new TimeoutClusterStateListener(){

                            @Override
                            public void postAdded() {
                                ClusterState clusterStateV2 = TransportMasterNodeOperationAction.this.clusterService.state();
                                if (!val$clusterState.nodes().masterNodeId().equals(clusterStateV2.nodes().masterNodeId())) {
                                    TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                    TransportMasterNodeOperationAction.this.innerExecute(val$request, listener, false);
                                }
                            }

                            @Override
                            public void onClose() {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                listener.onFailure(new NodeClosedException(TransportMasterNodeOperationAction.this.clusterService.localNode()));
                            }

                            @Override
                            public void onTimeout(TimeValue timeout) {
                                TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                listener.onFailure(new MasterNotDiscoveredException());
                            }

                            @Override
                            public void clusterChanged(ClusterChangedEvent event) {
                                if (event.nodesDelta().masterNodeChanged()) {
                                    TransportMasterNodeOperationAction.this.clusterService.remove(this);
                                    TransportMasterNodeOperationAction.this.innerExecute(val$request, listener, false);
                                }
                            }
                        });
                    } else {
                        listener.onFailure(exp);
                    }
                }
            });
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportMasterNodeOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportMasterNodeOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportMasterNodeOperationAction.this.logger.warn("Failed to send response", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

