/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class AcknowledgedResponse
extends ActionResponse {
    private boolean acknowledged;

    protected AcknowledgedResponse() {
    }

    protected AcknowledgedResponse(boolean acknowledged) {
        this.acknowledged = acknowledged;
    }

    public final boolean isAcknowledged() {
        return this.acknowledged;
    }

    protected void readAcknowledged(StreamInput in) throws IOException {
        this.readAcknowledged(in, null);
    }

    protected void readAcknowledged(StreamInput in, Version minVersion) throws IOException {
        if (minVersion == null || in.getVersion().onOrAfter(minVersion)) {
            this.acknowledged = in.readBoolean();
        }
    }

    protected void writeAcknowledged(StreamOutput out) throws IOException {
        this.writeAcknowledged(out, null);
    }

    protected void writeAcknowledged(StreamOutput out, Version minVersion) throws IOException {
        if (minVersion == null || out.getVersion().onOrAfter(minVersion)) {
            out.writeBoolean(this.acknowledged);
        }
    }
}

