/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.master;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public abstract class AcknowledgedRequest<T extends MasterNodeOperationRequest>
extends MasterNodeOperationRequest<T> {
    public static final TimeValue DEFAULT_ACK_TIMEOUT = TimeValue.timeValueSeconds(30L);
    protected TimeValue timeout = DEFAULT_ACK_TIMEOUT;

    protected AcknowledgedRequest() {
    }

    public final T timeout(String timeout) {
        this.timeout = TimeValue.parseTimeValue(timeout, this.timeout);
        return (T)this;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final TimeValue timeout() {
        return this.timeout;
    }

    protected void readTimeout(StreamInput in) throws IOException {
        this.readTimeout(in, null);
    }

    protected void readTimeout(StreamInput in, Version minVersion) throws IOException {
        if (minVersion == null || in.getVersion().onOrAfter(minVersion)) {
            this.timeout = TimeValue.readTimeValue(in);
        }
    }

    protected void writeTimeout(StreamOutput out) throws IOException {
        this.writeTimeout(out, null);
    }

    protected void writeTimeout(StreamOutput out, Version minVersion) throws IOException {
        if (minVersion == null || out.getVersion().onOrAfter(minVersion)) {
            this.timeout.writeTo(out);
        }
    }
}

