/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportBroadcastOperationAction<Request extends BroadcastOperationRequest, Response extends BroadcastOperationResponse, ShardRequest extends BroadcastShardOperationRequest, ShardResponse extends BroadcastShardOperationResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    protected final ThreadPool threadPool;
    final String transportAction;
    final String transportShardAction;
    final String executor;

    protected TransportBroadcastOperationAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.threadPool = threadPool;
        this.transportAction = this.transportAction();
        this.transportShardAction = this.transportAction() + "/s";
        this.executor = this.executor();
        transportService.registerHandler(this.transportAction, new TransportHandler());
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncBroadcastAction(this, request, listener).start();
    }

    protected abstract String transportAction();

    protected abstract String executor();

    protected abstract Request newRequest();

    protected abstract Response newResponse(Request var1, AtomicReferenceArray var2, ClusterState var3);

    protected abstract ShardRequest newShardRequest();

    protected abstract ShardRequest newShardRequest(ShardRouting var1, Request var2);

    protected abstract ShardResponse newShardResponse();

    protected abstract ShardResponse shardOperation(ShardRequest var1) throws ElasticSearchException;

    protected abstract GroupShardsIterator shards(ClusterState var1, Request var2, String[] var3);

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardRequest> {
        ShardTransportHandler() {
        }

        @Override
        public ShardRequest newInstance() {
            return TransportBroadcastOperationAction.this.newShardRequest();
        }

        @Override
        public String executor() {
            return TransportBroadcastOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse((TransportResponse)TransportBroadcastOperationAction.this.shardOperation(request));
        }
    }

    class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportBroadcastOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            if (((BroadcastOperationRequest)request).operationThreading() == BroadcastOperationThreading.NO_THREADS) {
                ((BroadcastOperationRequest)request).operationThreading(BroadcastOperationThreading.SINGLE_THREAD);
            }
            TransportBroadcastOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response response) {
                    try {
                        channel.sendResponse((TransportResponse)response);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportBroadcastOperationAction.this.logger.warn("Failed to send response", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncBroadcastAction {
        private final Request request;
        private final ActionListener<Response> listener;
        private final ClusterState clusterState;
        private final DiscoveryNodes nodes;
        private final GroupShardsIterator shardsIts;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray shardsResponses;
        final /* synthetic */ TransportBroadcastOperationAction this$0;

        AsyncBroadcastAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.request = request;
            this.listener = listener;
            this.clusterState = var1_1.clusterService.state();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(this.clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            String[] concreteIndices = this.clusterState.metaData().concreteIndices(((BroadcastOperationRequest)request).indices(), ((BroadcastOperationRequest)request).ignoreIndices(), true);
            blockException = var1_1.checkRequestBlock(this.clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = this.clusterState.nodes();
            this.shardsIts = var1_1.shards(this.clusterState, request, concreteIndices);
            this.expectedOps = this.shardsIts.size();
            this.shardsResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.shardsIts.size() == 0) {
                try {
                    this.listener.onResponse(this.this$0.newResponse(this.request, new AtomicReferenceArray(0), this.clusterState));
                }
                catch (Throwable e) {
                    this.listener.onFailure(e);
                }
            }
            ((BroadcastOperationRequest)this.request).beforeStart();
            int localOperations = 0;
            int shardIndex = -1;
            for (ShardIterator shardIt : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = shardIt.firstOrNull();
                if (shard != null) {
                    if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                        ++localOperations;
                        continue;
                    }
                    this.performOperation(shardIt, shardIndex, true);
                    continue;
                }
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            }
            if (localOperations > 0) {
                if (((BroadcastOperationRequest)this.request).operationThreading() == BroadcastOperationThreading.SINGLE_THREAD) {
                    ((BroadcastOperationRequest)this.request).beforeLocalFork();
                    this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                        @Override
                        public void run() {
                            int shardIndex = -1;
                            for (ShardIterator shardIt : AsyncBroadcastAction.this.shardsIts) {
                                ++shardIndex;
                                ShardRouting shard = shardIt.firstOrNull();
                                if (shard == null || !shard.currentNodeId().equals(AsyncBroadcastAction.this.nodes.localNodeId())) continue;
                                AsyncBroadcastAction.this.performOperation(shardIt, shardIndex, false);
                            }
                        }
                    });
                } else {
                    boolean localAsync;
                    boolean bl = localAsync = ((BroadcastOperationRequest)this.request).operationThreading() == BroadcastOperationThreading.THREAD_PER_SHARD;
                    if (localAsync) {
                        ((BroadcastOperationRequest)this.request).beforeLocalFork();
                    }
                    shardIndex = -1;
                    for (ShardIterator shardIt : this.shardsIts) {
                        ++shardIndex;
                        ShardRouting shard = shardIt.firstOrNull();
                        if (shard == null || !shard.currentNodeId().equals(this.nodes.localNodeId())) continue;
                        this.performOperation(shardIt, shardIndex, localAsync);
                    }
                }
            }
        }

        void performOperation(ShardIterator shardIt, int shardIndex, boolean localAsync) {
            this.performOperation(shardIt, shardIt.nextOrNull(), shardIndex, localAsync);
        }

        void performOperation(final ShardIterator shardIt, final ShardRouting shard, final int shardIndex, boolean localAsync) {
            if (shard == null) {
                this.onOperation(null, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                try {
                    Object shardRequest = this.this$0.newShardRequest(shard, this.request);
                    if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                        if (localAsync) {
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable((BroadcastShardOperationRequest)shardRequest, shardIt){
                                final /* synthetic */ BroadcastShardOperationRequest val$shardRequest;
                                final /* synthetic */ ShardIterator val$shardIt;
                                {
                                    this.val$shardRequest = broadcastShardOperationRequest;
                                    this.val$shardIt = shardIterator;
                                }

                                @Override
                                public void run() {
                                    try {
                                        AsyncBroadcastAction.this.onOperation(shard, shardIndex, AsyncBroadcastAction.this.this$0.shardOperation(this.val$shardRequest));
                                    }
                                    catch (Throwable e) {
                                        AsyncBroadcastAction.this.onOperation(shard, this.val$shardIt, shardIndex, e);
                                    }
                                }
                            });
                        } else {
                            this.onOperation(shard, shardIndex, this.this$0.shardOperation(shardRequest));
                        }
                    } else {
                        DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                        if (node == null) {
                            this.onOperation(shard, shardIt, shardIndex, new NoShardAvailableActionException(shardIt.shardId()));
                        } else {
                            this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, (TransportRequest)shardRequest, new BaseTransportResponseHandler<ShardResponse>(){

                                @Override
                                public ShardResponse newInstance() {
                                    return AsyncBroadcastAction.this.this$0.newShardResponse();
                                }

                                @Override
                                public String executor() {
                                    return "same";
                                }

                                @Override
                                public void handleResponse(ShardResponse response) {
                                    AsyncBroadcastAction.this.onOperation(shard, shardIndex, response);
                                }

                                @Override
                                public void handleException(TransportException e) {
                                    AsyncBroadcastAction.this.onOperation(shard, shardIt, shardIndex, e);
                                }
                            });
                        }
                    }
                }
                catch (Throwable e) {
                    this.onOperation(shard, shardIt, shardIndex, e);
                }
            }
        }

        void onOperation(ShardRouting shard, int shardIndex, ShardResponse response) {
            this.shardsResponses.set(shardIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim();
            }
        }

        void onOperation(@Nullable ShardRouting shard, ShardIterator shardIt, int shardIndex, Throwable t) {
            this.setFailure(shardIt, shardIndex, t);
            ShardRouting nextShard = shardIt.nextOrNull();
            if (nextShard != null) {
                if (t != null && this.this$0.logger.isTraceEnabled() && !TransportActions.isShardNotAvailableException(t)) {
                    if (shard != null) {
                        this.this$0.logger.trace(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    } else {
                        this.this$0.logger.trace(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    }
                }
                this.performOperation(shardIt, nextShard, shardIndex, true);
            } else {
                if (this.this$0.logger.isDebugEnabled() && t != null && !TransportActions.isShardNotAvailableException(t)) {
                    if (shard != null) {
                        this.this$0.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    } else {
                        this.this$0.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    }
                }
                if (this.expectedOps == this.counterOps.incrementAndGet()) {
                    this.finishHim();
                }
            }
        }

        void finishHim() {
            try {
                this.listener.onResponse(this.this$0.newResponse(this.request, this.shardsResponses, this.clusterState));
            }
            catch (Throwable e) {
                this.listener.onFailure(e);
            }
        }

        void setFailure(ShardIterator shardIt, int shardIndex, Throwable t) {
            Object response;
            if (TransportActions.isShardNotAvailableException(t)) {
                return;
            }
            if (!(t instanceof BroadcastShardOperationFailedException)) {
                t = new BroadcastShardOperationFailedException(shardIt.shardId(), t);
            }
            if ((response = this.shardsResponses.get(shardIndex)) == null) {
                this.shardsResponses.set(shardIndex, t);
            }
            if (!(response instanceof Throwable)) {
                return;
            }
            if (TransportActions.isReadOverrideException(t)) {
                this.shardsResponses.set(shardIndex, t);
            }
        }
    }
}

