/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BroadcastOperationResponse
extends ActionResponse {
    private static final ShardOperationFailedException[] EMPTY = new ShardOperationFailedException[0];
    private int totalShards;
    private int successfulShards;
    private int failedShards;
    private ShardOperationFailedException[] shardFailures = EMPTY;

    protected BroadcastOperationResponse() {
    }

    protected BroadcastOperationResponse(int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        this.totalShards = totalShards;
        this.successfulShards = successfulShards;
        this.failedShards = failedShards;
        this.shardFailures = shardFailures == null ? EMPTY : shardFailures.toArray(new ShardOperationFailedException[shardFailures.size()]);
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public int getSuccessfulShards() {
        return this.successfulShards;
    }

    public int getFailedShards() {
        return this.failedShards;
    }

    public ShardOperationFailedException[] getShardFailures() {
        return this.shardFailures;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.totalShards = in.readVInt();
        this.successfulShards = in.readVInt();
        this.failedShards = in.readVInt();
        int size2 = in.readVInt();
        if (size2 > 0) {
            this.shardFailures = new ShardOperationFailedException[size2];
            for (int i = 0; i < size2; ++i) {
                this.shardFailures[i] = DefaultShardOperationFailedException.readShardOperationFailed(in);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.totalShards);
        out.writeVInt(this.successfulShards);
        out.writeVInt(this.failedShards);
        out.writeVInt(this.shardFailures.length);
        for (ShardOperationFailedException exp : this.shardFailures) {
            exp.writeTo(out);
        }
    }
}

