/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class TransportSearchTypeAction
extends TransportAction<SearchRequest, SearchResponse> {
    protected final ClusterService clusterService;
    protected final SearchServiceTransportAction searchService;
    protected final SearchPhaseController searchPhaseController;

    public TransportSearchTypeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    protected abstract class BaseAsyncAction<FirstResult extends SearchPhaseResult> {
        protected final ActionListener<SearchResponse> listener;
        protected final GroupShardsIterator shardsIts;
        protected final SearchRequest request;
        protected final ClusterState clusterState;
        protected final DiscoveryNodes nodes;
        protected final int expectedSuccessfulOps;
        private final int expectedTotalOps;
        protected final AtomicInteger successulOps = new AtomicInteger();
        private final AtomicInteger totalOps = new AtomicInteger();
        protected final AtomicArray<FirstResult> firstResults;
        private volatile AtomicArray<ShardSearchFailure> shardFailures;
        private final Object shardFailuresMutex = new Object();
        protected volatile ScoreDoc[] sortedShardList;
        protected final long startTime = System.currentTimeMillis();

        protected BaseAsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            String[] concreteIndices;
            this.request = request;
            this.listener = listener;
            this.clusterState = TransportSearchTypeAction.this.clusterService.state();
            this.nodes = this.clusterState.nodes();
            this.clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
            for (String index : concreteIndices = this.clusterState.metaData().concreteIndices(request.indices(), request.ignoreIndices(), true)) {
                this.clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index);
            }
            Map<String, Set<String>> routingMap = this.clusterState.metaData().resolveSearchRouting(request.routing(), request.indices());
            this.shardsIts = TransportSearchTypeAction.this.clusterService.operationRouting().searchShards(this.clusterState, request.indices(), concreteIndices, routingMap, request.preference());
            this.expectedSuccessfulOps = this.shardsIts.size();
            this.expectedTotalOps = this.shardsIts.totalSizeWith1ForEmpty();
            this.firstResults = new AtomicArray(this.shardsIts.size());
        }

        public void start() {
            if (this.expectedSuccessfulOps == 0) {
                this.listener.onResponse(new SearchResponse(InternalSearchResponse.EMPTY, null, 0, 0, System.currentTimeMillis() - this.startTime, ShardSearchFailure.EMPTY_ARRAY));
                return;
            }
            this.request.beforeStart();
            int localOperations = 0;
            int shardIndex = -1;
            for (ShardIterator shardIt : this.shardsIts) {
                ++shardIndex;
                ShardRouting shard = shardIt.firstOrNull();
                if (shard != null) {
                    if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                        ++localOperations;
                        continue;
                    }
                    this.performFirstPhase(shardIndex, shardIt);
                    continue;
                }
                this.onFirstPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    this.request.beforeLocalFork();
                    TransportSearchTypeAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            int shardIndex = -1;
                            for (ShardIterator shardIt : BaseAsyncAction.this.shardsIts) {
                                ++shardIndex;
                                ShardRouting shard = shardIt.firstOrNull();
                                if (shard == null || !shard.currentNodeId().equals(BaseAsyncAction.this.nodes.localNodeId())) continue;
                                BaseAsyncAction.this.performFirstPhase(shardIndex, shardIt);
                            }
                        }
                    });
                } else {
                    boolean localAsync;
                    boolean bl = localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    if (localAsync) {
                        this.request.beforeLocalFork();
                    }
                    shardIndex = -1;
                    for (final ShardIterator shardIt : this.shardsIts) {
                        final int fShardIndex = ++shardIndex;
                        ShardRouting shard = shardIt.firstOrNull();
                        if (shard == null || !shard.currentNodeId().equals(this.nodes.localNodeId())) continue;
                        if (localAsync) {
                            try {
                                TransportSearchTypeAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        BaseAsyncAction.this.performFirstPhase(fShardIndex, shardIt);
                                    }
                                });
                            }
                            catch (Throwable t) {
                                this.onFirstPhaseResult(shardIndex, shard, shard.currentNodeId(), shardIt, t);
                            }
                            continue;
                        }
                        this.performFirstPhase(fShardIndex, shardIt);
                    }
                }
            }
        }

        void performFirstPhase(int shardIndex, ShardIterator shardIt) {
            this.performFirstPhase(shardIndex, shardIt, shardIt.nextOrNull());
        }

        void performFirstPhase(final int shardIndex, final ShardIterator shardIt, final ShardRouting shard) {
            if (shard == null) {
                this.onFirstPhaseResult(shardIndex, null, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
            } else {
                final DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                if (node == null) {
                    this.onFirstPhaseResult(shardIndex, shard, null, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
                } else {
                    String[] filteringAliases = this.clusterState.metaData().filteringAliases(shard.index(), this.request.indices());
                    this.sendExecuteFirstPhase(node, TransportSearchHelper.internalSearchRequest(shard, this.shardsIts.size(), this.request, filteringAliases, this.startTime), new SearchServiceListener<FirstResult>(){

                        @Override
                        public void onResult(FirstResult result2) {
                            BaseAsyncAction.this.onFirstPhaseResult(shardIndex, shard, result2, shardIt);
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            BaseAsyncAction.this.onFirstPhaseResult(shardIndex, shard, node.id(), shardIt, t);
                        }
                    });
                }
            }
        }

        void onFirstPhaseResult(int shardIndex, ShardRouting shard, FirstResult result2, ShardIterator shardIt) {
            result2.shardTarget(new SearchShardTarget(shard.currentNodeId(), shard.index(), shard.id()));
            this.processFirstPhaseResult(shardIndex, shard, result2);
            int xTotalOps = this.totalOps.addAndGet(shardIt.remaining() + 1);
            this.successulOps.incrementAndGet();
            if (xTotalOps == this.expectedTotalOps) {
                try {
                    this.innerMoveToSecondPhase();
                }
                catch (Throwable e) {
                    if (TransportSearchTypeAction.this.logger.isDebugEnabled()) {
                        TransportSearchTypeAction.this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "] while moving to second phase", e, new Object[0]);
                    }
                    this.listener.onFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
                }
            }
        }

        void onFirstPhaseResult(final int shardIndex, @Nullable ShardRouting shard, @Nullable String nodeId, final ShardIterator shardIt, Throwable t) {
            SearchShardTarget shardTarget = new SearchShardTarget(nodeId, shardIt.shardId().getIndex(), shardIt.shardId().getId());
            this.addShardFailure(shardIndex, shardTarget, t);
            if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
                if (TransportSearchTypeAction.this.logger.isDebugEnabled() && t != null && !TransportActions.isShardNotAvailableException(t)) {
                    if (shard != null) {
                        TransportSearchTypeAction.this.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    } else {
                        TransportSearchTypeAction.this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    }
                }
                if (this.successulOps.get() == 0) {
                    if (TransportSearchTypeAction.this.logger.isDebugEnabled()) {
                        TransportSearchTypeAction.this.logger.debug("All shards failed for phase: [{}]", this.firstPhaseName(), t);
                    }
                    this.listener.onFailure(new SearchPhaseExecutionException(this.firstPhaseName(), "all shards failed", this.buildShardFailures()));
                } else {
                    try {
                        this.innerMoveToSecondPhase();
                    }
                    catch (Throwable e) {
                        this.listener.onFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
                    }
                }
            } else {
                boolean lastShard;
                final ShardRouting nextShard = shardIt.nextOrNull();
                boolean bl = lastShard = nextShard == null;
                if (TransportSearchTypeAction.this.logger.isTraceEnabled() && t != null) {
                    TransportSearchTypeAction.this.logger.trace(this.executionFailureMsg(shard, shardIt, this.request, lastShard), t, new Object[0]);
                }
                if (!lastShard) {
                    try {
                        TransportSearchTypeAction.this.threadPool.executor("search").execute(new Runnable(){

                            @Override
                            public void run() {
                                BaseAsyncAction.this.performFirstPhase(shardIndex, shardIt, nextShard);
                            }
                        });
                    }
                    catch (Throwable t1) {
                        this.onFirstPhaseResult(shardIndex, shard, shard.currentNodeId(), shardIt, t1);
                    }
                } else if (TransportSearchTypeAction.this.logger.isDebugEnabled() && !TransportSearchTypeAction.this.logger.isTraceEnabled() && t != null && !TransportActions.isShardNotAvailableException(t)) {
                    TransportSearchTypeAction.this.logger.debug(this.executionFailureMsg(shard, shardIt, this.request, lastShard), t, new Object[0]);
                }
            }
        }

        private String executionFailureMsg(@Nullable ShardRouting shard, ShardIterator shardIt, SearchRequest request, boolean lastShard) {
            if (shard != null) {
                return shard.shortSummary() + ": Failed to execute [" + request + "] lastShard [" + lastShard + "]";
            }
            return shardIt.shardId() + ": Failed to execute [" + request + "] lastShard [" + lastShard + "]";
        }

        protected final long buildTookInMillis() {
            return System.currentTimeMillis() - this.startTime;
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures;
            if (shardFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            List<AtomicArray.Entry<ShardSearchFailure>> entries = shardFailures.asList();
            ShardSearchFailure[] failures2 = new ShardSearchFailure[entries.size()];
            for (int i = 0; i < failures2.length; ++i) {
                failures2[i] = (ShardSearchFailure)entries.get((int)i).value;
            }
            return failures2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void addShardFailure(int shardIndex, @Nullable SearchShardTarget shardTarget, Throwable t) {
            ShardSearchFailure failure2;
            if (TransportActions.isShardNotAvailableException(t)) {
                return;
            }
            if (this.shardFailures == null) {
                Object object = this.shardFailuresMutex;
                synchronized (object) {
                    if (this.shardFailures == null) {
                        this.shardFailures = new AtomicArray(this.shardsIts.size());
                    }
                }
            }
            if ((failure2 = this.shardFailures.get(shardIndex)) == null) {
                this.shardFailures.set(shardIndex, new ShardSearchFailure(t, shardTarget));
            } else if (TransportActions.isReadOverrideException(t)) {
                this.shardFailures.set(shardIndex, new ShardSearchFailure(t, shardTarget));
            }
        }

        protected void releaseIrrelevantSearchContexts(AtomicArray<? extends QuerySearchResultProvider> queryResults, AtomicArray<IntArrayList> docIdsToLoad) {
            if (docIdsToLoad == null) {
                return;
            }
            if (this.request.scroll() == null) {
                for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry2 : queryResults.asList()) {
                    DiscoveryNode node;
                    if (docIdsToLoad.get(entry2.index) != null || (node = this.nodes.get(((QuerySearchResultProvider)entry2.value).queryResult().shardTarget().nodeId())) == null) continue;
                    TransportSearchTypeAction.this.searchService.sendFreeContext(node, ((QuerySearchResultProvider)entry2.value).queryResult().id(), this.request);
                }
            }
        }

        protected abstract void sendExecuteFirstPhase(DiscoveryNode var1, ShardSearchRequest var2, SearchServiceListener<FirstResult> var3);

        protected final void processFirstPhaseResult(int shardIndex, ShardRouting shard, FirstResult result2) {
            this.firstResults.set(shardIndex, result2);
            AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures;
            if (shardFailures != null) {
                shardFailures.set(shardIndex, null);
            }
        }

        final void innerMoveToSecondPhase() throws Exception {
            if (TransportSearchTypeAction.this.logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                boolean hadOne = false;
                for (int i = 0; i < this.firstResults.length(); ++i) {
                    SearchPhaseResult result2 = (SearchPhaseResult)this.firstResults.get(i);
                    if (result2 == null) continue;
                    if (hadOne) {
                        sb.append(",");
                    } else {
                        hadOne = true;
                    }
                    sb.append(result2.shardTarget());
                }
                TransportSearchTypeAction.this.logger.trace("Moving to second phase, based on results from: {} (cluster state version: {})", sb, this.clusterState.version());
            }
            this.moveToSecondPhase();
        }

        protected abstract void moveToSecondPhase() throws Exception;

        protected abstract String firstPhaseName();
    }
}

