/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryThenFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryThenFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        final AtomicArray<QuerySearchResult> queryResults;
        final AtomicArray<FetchSearchResult> fetchResults;
        final AtomicArray<IntArrayList> docIdsToLoad;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(TransportSearchDfsQueryThenFetchAction.this, request, listener);
            this.queryResults = new AtomicArray(this.firstResults.length());
            this.fetchResults = new AtomicArray(this.firstResults.length());
            this.docIdsToLoad = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() {
            final AggregatedDfs dfs = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.aggregateDfs(this.firstResults);
            final AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
            int localOperations = 0;
            for (AtomicArray.Entry entry2 : this.firstResults.asList()) {
                DfsSearchResult dfsResult = (DfsSearchResult)entry2.value;
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                this.executeQuery(entry2.index, dfsResult, counter, querySearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (AtomicArray.Entry entry2 : AsyncAction.this.firstResults.asList()) {
                                DfsSearchResult dfsResult = (DfsSearchResult)entry2.value;
                                DiscoveryNode node = AsyncAction.this.nodes.get(dfsResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                QuerySearchRequest querySearchRequest = new QuerySearchRequest(AsyncAction.this.request, dfsResult.id(), dfs);
                                AsyncAction.this.executeQuery(entry2.index, dfsResult, counter, querySearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final AtomicArray.Entry entry3 : this.firstResults.asList()) {
                        final DfsSearchResult dfsResult = (DfsSearchResult)entry3.value;
                        final DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                        try {
                            if (localAsync) {
                                TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executeQuery(entry3.index, dfsResult, counter, querySearchRequest, node);
                                    }
                                });
                                continue;
                            }
                            this.executeQuery(entry3.index, dfsResult, counter, querySearchRequest, node);
                        }
                        catch (Throwable t) {
                            this.onQueryFailure(t, querySearchRequest, entry3.index, dfsResult, counter);
                        }
                    }
                }
            }
        }

        void executeQuery(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, final QuerySearchRequest querySearchRequest, DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteQuery(node, querySearchRequest, new SearchServiceListener<QuerySearchResult>(){

                @Override
                public void onResult(QuerySearchResult result2) {
                    result2.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryResults.set(shardIndex, result2);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.executeFetchPhase();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onQueryFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
            });
        }

        void onQueryFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
            if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
            }
            this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
            this.successulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.executeFetchPhase();
            }
        }

        void executeFetchPhase() {
            try {
                this.innerExecuteFetchPhase();
            }
            catch (Throwable e) {
                this.listener.onFailure(new ReduceSearchPhaseException("query", "", e, this.buildShardFailures()));
            }
        }

        void innerExecuteFetchPhase() {
            this.sortedShardList = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.sortDocs(this.queryResults);
            TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.fillDocIdsToLoad(this.docIdsToLoad, this.sortedShardList);
            if (this.docIdsToLoad.asList().isEmpty()) {
                this.finishHim();
                return;
            }
            final AtomicInteger counter = new AtomicInteger(this.docIdsToLoad.asList().size());
            int localOperations = 0;
            for (AtomicArray.Entry<IntArrayList> entry2 : this.docIdsToLoad.asList()) {
                QuerySearchResult queryResult = this.queryResults.get(entry2.index);
                DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry2.value);
                this.executeFetch(entry2.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (AtomicArray.Entry<IntArrayList> entry2 : AsyncAction.this.docIdsToLoad.asList()) {
                                QuerySearchResult queryResult = AsyncAction.this.queryResults.get(entry2.index);
                                DiscoveryNode node = AsyncAction.this.nodes.get(queryResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(AsyncAction.this.request, queryResult.id(), (IntArrayList)entry2.value);
                                AsyncAction.this.executeFetch(entry2.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final AtomicArray.Entry<IntArrayList> entry3 : this.docIdsToLoad.asList()) {
                        final QuerySearchResult queryResult = this.queryResults.get(entry3.index);
                        final DiscoveryNode node = this.nodes.get(queryResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final FetchSearchRequest fetchSearchRequest = new FetchSearchRequest(this.request, queryResult.id(), (IntArrayList)entry3.value);
                        try {
                            if (localAsync) {
                                TransportSearchDfsQueryThenFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executeFetch(entry3.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                                    }
                                });
                                continue;
                            }
                            this.executeFetch(entry3.index, queryResult.shardTarget(), counter, fetchSearchRequest, node);
                        }
                        catch (Throwable t) {
                            this.onFetchFailure(t, fetchSearchRequest, entry3.index, queryResult.shardTarget(), counter);
                        }
                    }
                }
            }
        }

        void executeFetch(final int shardIndex, final SearchShardTarget shardTarget, final AtomicInteger counter, final FetchSearchRequest fetchSearchRequest, DiscoveryNode node) {
            TransportSearchDfsQueryThenFetchAction.this.searchService.sendExecuteFetch(node, fetchSearchRequest, new SearchServiceListener<FetchSearchResult>(){

                @Override
                public void onResult(FetchSearchResult result2) {
                    result2.shardTarget(shardTarget);
                    AsyncAction.this.fetchResults.set(shardIndex, result2);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onFetchFailure(t, fetchSearchRequest, shardIndex, shardTarget, counter);
                }
            });
        }

        void onFetchFailure(Throwable t, FetchSearchRequest fetchSearchRequest, int shardIndex, SearchShardTarget shardTarget, AtomicInteger counter) {
            if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryThenFetchAction.this.logger.debug("[{}] Failed to execute fetch phase", t, fetchSearchRequest.id());
            }
            this.addShardFailure(shardIndex, shardTarget, t);
            this.successulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure2 = new ReduceSearchPhaseException("merge", "", e, this.buildShardFailures());
                if (TransportSearchDfsQueryThenFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchDfsQueryThenFetchAction.this.logger.debug("failed to reduce search", failure2, new Object[0]);
                }
                this.listener.onFailure(failure2);
            }
            finally {
                this.releaseIrrelevantSearchContexts(this.queryResults, this.docIdsToLoad);
            }
        }

        void innerFinishHim() throws Exception {
            InternalSearchResponse internalResponse = TransportSearchDfsQueryThenFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryResults, this.fetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

