/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.search.type.TransportSearchTypeAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class TransportSearchDfsQueryAndFetchAction
extends TransportSearchTypeAction {
    @Inject
    public TransportSearchDfsQueryAndFetchAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool, clusterService, searchService, searchPhaseController);
    }

    @Override
    protected void doExecute(SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        new AsyncAction(searchRequest, listener).start();
    }

    private class AsyncAction
    extends TransportSearchTypeAction.BaseAsyncAction<DfsSearchResult> {
        private final AtomicArray<QueryFetchSearchResult> queryFetchResults;

        private AsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            super(request, listener);
            this.queryFetchResults = new AtomicArray(this.firstResults.length());
        }

        @Override
        protected String firstPhaseName() {
            return "dfs";
        }

        @Override
        protected void sendExecuteFirstPhase(DiscoveryNode node, ShardSearchRequest request, SearchServiceListener<DfsSearchResult> listener) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteDfs(node, request, listener);
        }

        @Override
        protected void moveToSecondPhase() {
            final AggregatedDfs dfs = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.aggregateDfs(this.firstResults);
            final AtomicInteger counter = new AtomicInteger(this.firstResults.asList().size());
            int localOperations = 0;
            for (AtomicArray.Entry entry2 : this.firstResults.asList()) {
                DfsSearchResult dfsResult = (DfsSearchResult)entry2.value;
                DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                if (node.id().equals(this.nodes.localNodeId())) {
                    ++localOperations;
                    continue;
                }
                QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                this.executeSecondPhase(entry2.index, dfsResult, counter, node, querySearchRequest);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    TransportSearchDfsQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (AtomicArray.Entry entry2 : AsyncAction.this.firstResults.asList()) {
                                DfsSearchResult dfsResult = (DfsSearchResult)entry2.value;
                                DiscoveryNode node = AsyncAction.this.nodes.get(dfsResult.shardTarget().nodeId());
                                if (!node.id().equals(AsyncAction.this.nodes.localNodeId())) continue;
                                QuerySearchRequest querySearchRequest = new QuerySearchRequest(AsyncAction.this.request, dfsResult.id(), dfs);
                                AsyncAction.this.executeSecondPhase(entry2.index, dfsResult, counter, node, querySearchRequest);
                            }
                        }
                    });
                } else {
                    boolean localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    for (final AtomicArray.Entry entry3 : this.firstResults.asList()) {
                        final DfsSearchResult dfsResult = (DfsSearchResult)entry3.value;
                        final DiscoveryNode node = this.nodes.get(dfsResult.shardTarget().nodeId());
                        if (!node.id().equals(this.nodes.localNodeId())) continue;
                        final QuerySearchRequest querySearchRequest = new QuerySearchRequest(this.request, dfsResult.id(), dfs);
                        try {
                            if (localAsync) {
                                TransportSearchDfsQueryAndFetchAction.this.threadPool.executor("search").execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        AsyncAction.this.executeSecondPhase(entry3.index, dfsResult, counter, node, querySearchRequest);
                                    }
                                });
                                continue;
                            }
                            this.executeSecondPhase(entry3.index, dfsResult, counter, node, querySearchRequest);
                        }
                        catch (Throwable t) {
                            this.onSecondPhaseFailure(t, querySearchRequest, entry3.index, dfsResult, counter);
                        }
                    }
                }
            }
        }

        void executeSecondPhase(final int shardIndex, final DfsSearchResult dfsResult, final AtomicInteger counter, DiscoveryNode node, final QuerySearchRequest querySearchRequest) {
            TransportSearchDfsQueryAndFetchAction.this.searchService.sendExecuteFetch(node, querySearchRequest, new SearchServiceListener<QueryFetchSearchResult>(){

                @Override
                public void onResult(QueryFetchSearchResult result2) {
                    result2.shardTarget(dfsResult.shardTarget());
                    AsyncAction.this.queryFetchResults.set(shardIndex, result2);
                    if (counter.decrementAndGet() == 0) {
                        AsyncAction.this.finishHim();
                    }
                }

                @Override
                public void onFailure(Throwable t) {
                    AsyncAction.this.onSecondPhaseFailure(t, querySearchRequest, shardIndex, dfsResult, counter);
                }
            });
        }

        void onSecondPhaseFailure(Throwable t, QuerySearchRequest querySearchRequest, int shardIndex, DfsSearchResult dfsResult, AtomicInteger counter) {
            if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                TransportSearchDfsQueryAndFetchAction.this.logger.debug("[{}] Failed to execute query phase", t, querySearchRequest.id());
            }
            this.addShardFailure(shardIndex, dfsResult.shardTarget(), t);
            this.successulOps.decrementAndGet();
            if (counter.decrementAndGet() == 0) {
                this.finishHim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finishHim() {
            try {
                this.innerFinishHim();
            }
            catch (Throwable e) {
                ReduceSearchPhaseException failure2 = new ReduceSearchPhaseException("query_fetch", "", e, this.buildShardFailures());
                if (TransportSearchDfsQueryAndFetchAction.this.logger.isDebugEnabled()) {
                    TransportSearchDfsQueryAndFetchAction.this.logger.debug("failed to reduce search", failure2, new Object[0]);
                }
                this.listener.onFailure(failure2);
            }
        }

        void innerFinishHim() throws Exception {
            this.sortedShardList = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.sortDocs(this.queryFetchResults);
            InternalSearchResponse internalResponse = TransportSearchDfsQueryAndFetchAction.this.searchPhaseController.merge(this.sortedShardList, this.queryFetchResults, this.queryFetchResults);
            String scrollId = null;
            if (this.request.scroll() != null) {
                scrollId = TransportSearchHelper.buildScrollId(this.request.searchType(), (AtomicArray<? extends SearchPhaseResult>)this.firstResults, null);
            }
            this.listener.onResponse(new SearchResponse(internalResponse, scrollId, this.expectedSuccessfulOps, this.successulOps.get(), this.buildTookInMillis(), this.buildShardFailures()));
        }
    }
}

