/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.explain;

import java.io.IOException;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.index.get.GetResult;

public class ExplainResponse
extends ActionResponse {
    private boolean exists;
    private Explanation explanation;
    private GetResult getResult;

    ExplainResponse() {
    }

    public ExplainResponse(boolean exists2) {
        this.exists = exists2;
    }

    public ExplainResponse(boolean exists2, Explanation explanation) {
        this.exists = exists2;
        this.explanation = explanation;
    }

    public ExplainResponse(boolean exists2, Explanation explanation, GetResult getResult) {
        this.exists = exists2;
        this.explanation = explanation;
        this.getResult = getResult;
    }

    public Explanation getExplanation() {
        return this.explanation;
    }

    public boolean isMatch() {
        return this.explanation != null && this.explanation.isMatch();
    }

    public boolean hasExplanation() {
        return this.explanation != null;
    }

    public boolean isExists() {
        return this.exists;
    }

    public GetResult getGetResult() {
        return this.getResult;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.exists = in.readBoolean();
        if (in.readBoolean()) {
            this.explanation = Lucene.readExplanation(in);
        }
        if (in.readBoolean()) {
            this.getResult = GetResult.readGetResult(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.exists);
        if (this.explanation == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Lucene.writeExplanation(out, this.explanation);
        }
        if (this.getResult == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.getResult.writeTo(out);
        }
    }
}

