/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryRequest;
import org.elasticsearch.action.deletebyquery.ShardDeleteByQueryResponse;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteByQueryAction
extends TransportShardReplicationOperationAction<ShardDeleteByQueryRequest, ShardDeleteByQueryRequest, ShardDeleteByQueryResponse> {
    private final ScriptService scriptService;
    private final CacheRecycler cacheRecycler;

    @Inject
    public TransportShardDeleteByQueryAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ScriptService scriptService, CacheRecycler cacheRecycler) {
        super(settings, transportService, clusterService, indicesService, threadPool, shardStateAction);
        this.scriptService = scriptService;
        this.cacheRecycler = cacheRecycler;
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected ShardDeleteByQueryRequest newRequestInstance() {
        return new ShardDeleteByQueryRequest();
    }

    @Override
    protected ShardDeleteByQueryRequest newReplicaRequestInstance() {
        return new ShardDeleteByQueryRequest();
    }

    @Override
    protected ShardDeleteByQueryResponse newResponseInstance() {
        return new ShardDeleteByQueryResponse();
    }

    @Override
    protected String transportAction() {
        return "deleteByQuery/shard";
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ShardDeleteByQueryRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ShardDeleteByQueryRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.WRITE, request.index());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse, ShardDeleteByQueryRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        IndexService indexService = this.indicesService.indexServiceSafe(((ShardDeleteByQueryRequest)shardRequest.request).index());
        IndexShard indexShard = indexService.shardSafe(shardRequest.shardId);
        SearchContext.setCurrent(new SearchContext(0L, new ShardSearchRequest().types(request.types()), null, indexShard.acquireSearcher("delete_by_query", IndexShard.Mode.WRITE), indexService, indexShard, this.scriptService, this.cacheRecycler));
        try {
            Engine.DeleteByQuery deleteByQuery = indexShard.prepareDeleteByQuery(request.querySource(), request.filteringAliases(), request.types()).origin(Engine.Operation.Origin.PRIMARY);
            SearchContext.current().parsedQuery(new ParsedQuery(deleteByQuery.query(), ImmutableMap.<String, Filter>of()));
            indexShard.deleteByQuery(deleteByQuery);
        }
        finally {
            SearchContext searchContext = SearchContext.current();
            searchContext.clearAndRelease();
            SearchContext.removeCurrent();
        }
        return new TransportShardReplicationOperationAction.PrimaryResponse<ShardDeleteByQueryResponse, ShardDeleteByQueryRequest>((ShardDeleteByQueryRequest)shardRequest.request, new ShardDeleteByQueryResponse(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        ShardDeleteByQueryRequest request = (ShardDeleteByQueryRequest)shardRequest.request;
        IndexService indexService = this.indicesService.indexServiceSafe(((ShardDeleteByQueryRequest)shardRequest.request).index());
        IndexShard indexShard = indexService.shardSafe(shardRequest.shardId);
        SearchContext.setCurrent(new SearchContext(0L, new ShardSearchRequest().types(request.types()), null, indexShard.acquireSearcher("delete_by_query", IndexShard.Mode.WRITE), indexService, indexShard, this.scriptService, this.cacheRecycler));
        try {
            Engine.DeleteByQuery deleteByQuery = indexShard.prepareDeleteByQuery(request.querySource(), request.filteringAliases(), request.types()).origin(Engine.Operation.Origin.REPLICA);
            SearchContext.current().parsedQuery(new ParsedQuery(deleteByQuery.query(), ImmutableMap.<String, Filter>of()));
            indexShard.deleteByQuery(deleteByQuery);
        }
        finally {
            SearchContext searchContext = SearchContext.current();
            searchContext.clearAndRelease();
            SearchContext.removeCurrent();
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, ShardDeleteByQueryRequest request) {
        GroupShardsIterator group = this.clusterService.operationRouting().deleteByQueryShards(this.clusterService.state(), request.index(), request.routing());
        for (ShardIterator shardIt : group) {
            if (shardIt.shardId().id() != request.shardId()) continue;
            return shardIt;
        }
        throw new ElasticSearchIllegalStateException("No shards iterator found for shard [" + request.shardId() + "]");
    }
}

