/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.deletebyquery;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.deletebyquery.IndexDeleteByQueryRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ShardDeleteByQueryRequest
extends ShardReplicationOperationRequest<ShardDeleteByQueryRequest> {
    private int shardId;
    private BytesReference querySource;
    private String[] types = Strings.EMPTY_ARRAY;
    @Nullable
    private Set<String> routing;
    @Nullable
    private String[] filteringAliases;

    ShardDeleteByQueryRequest(IndexDeleteByQueryRequest request, int shardId) {
        super(request);
        this.index = request.index();
        this.querySource = request.querySource();
        this.types = request.types();
        this.shardId = shardId;
        this.replicationType(request.replicationType());
        this.consistencyLevel(request.consistencyLevel());
        this.timeout = request.timeout();
        this.routing = request.routing();
        this.filteringAliases = request.filteringAliases();
    }

    ShardDeleteByQueryRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.querySource == null) {
            ValidateActions.addValidationError("querySource is missing", validationException);
        }
        return validationException;
    }

    public int shardId() {
        return this.shardId;
    }

    BytesReference querySource() {
        return this.querySource;
    }

    public String[] types() {
        return this.types;
    }

    public Set<String> routing() {
        return this.routing;
    }

    public String[] filteringAliases() {
        return this.filteringAliases;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        int aliasesSize;
        super.readFrom(in);
        this.querySource = in.readBytesReference();
        this.shardId = in.readVInt();
        this.types = in.readStringArray();
        int routingSize = in.readVInt();
        if (routingSize > 0) {
            this.routing = new HashSet<String>(routingSize);
            for (int i = 0; i < routingSize; ++i) {
                this.routing.add(in.readString());
            }
        }
        if ((aliasesSize = in.readVInt()) > 0) {
            this.filteringAliases = new String[aliasesSize];
            for (int i = 0; i < aliasesSize; ++i) {
                this.filteringAliases[i] = in.readString();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.querySource);
        out.writeVInt(this.shardId);
        out.writeStringArray(this.types);
        if (this.routing != null) {
            out.writeVInt(this.routing.size());
            for (String r : this.routing) {
                out.writeString(r);
            }
        } else {
            out.writeVInt(0);
        }
        if (this.filteringAliases != null) {
            out.writeVInt(this.filteringAliases.length);
            for (String alias : this.filteringAliases) {
                out.writeString(alias);
            }
        } else {
            out.writeVInt(0);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.querySource, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "delete_by_query {[" + this.index + "]" + Arrays.toString(this.types) + ", query [" + sSource + "]}";
    }
}

