/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;

public class CountRequest
extends BroadcastOperationRequest<CountRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    public static final float DEFAULT_MIN_SCORE = -1.0f;
    private float minScore = -1.0f;
    @Nullable
    protected String routing;
    @Nullable
    private String preference;
    private BytesReference querySource;
    private boolean querySourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    long nowInMillis;

    CountRequest() {
    }

    public CountRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    @Override
    protected void beforeStart() {
        if (this.querySourceUnsafe) {
            this.querySource = this.querySource.copyBytesArray();
            this.querySourceUnsafe = false;
        }
    }

    float minScore() {
        return this.minScore;
    }

    public CountRequest minScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    BytesReference querySource() {
        return this.querySource;
    }

    public CountRequest query(QueryBuilder queryBuilder) {
        this.querySource = queryBuilder.buildAsBytes();
        this.querySourceUnsafe = false;
        return this;
    }

    public CountRequest query(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(querySource);
            return this.query(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    public CountRequest query(XContentBuilder builder) {
        this.querySource = builder.bytes();
        this.querySourceUnsafe = false;
        return this;
    }

    public CountRequest query(String querySource) {
        this.querySource = new BytesArray(querySource);
        this.querySourceUnsafe = false;
        return this;
    }

    public CountRequest query(byte[] querySource) {
        return this.query(querySource, 0, querySource.length, false);
    }

    public CountRequest query(byte[] querySource, int offset, int length, boolean unsafe) {
        return this.query(new BytesArray(querySource, offset, length), unsafe);
    }

    public CountRequest query(BytesReference querySource, boolean unsafe) {
        this.querySource = querySource;
        this.querySourceUnsafe = unsafe;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public CountRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public CountRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public CountRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public CountRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.querySourceUnsafe = false;
        this.querySource = in.readBytesReference();
        this.types = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.querySource);
        out.writeStringArray(this.types);
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.querySource, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", querySource[" + sSource + "]";
    }
}

