/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;

public class BulkRequestBuilder
extends ActionRequestBuilder<BulkRequest, BulkResponse, BulkRequestBuilder> {
    public BulkRequestBuilder(Client client) {
        super((InternalClient)client, new BulkRequest());
    }

    public BulkRequestBuilder add(IndexRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(IndexRequestBuilder request) {
        ((BulkRequest)this.request).add((IndexRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(DeleteRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(DeleteRequestBuilder request) {
        ((BulkRequest)this.request).add((DeleteRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(UpdateRequest request) {
        ((BulkRequest)this.request).add(request);
        return this;
    }

    public BulkRequestBuilder add(UpdateRequestBuilder request) {
        ((BulkRequest)this.request).add((UpdateRequest)request.request());
        return this;
    }

    public BulkRequestBuilder add(byte[] data2, int from2, int length, boolean contentUnsafe) throws Exception {
        ((BulkRequest)this.request).add(data2, from2, length, contentUnsafe, null, null);
        return this;
    }

    public BulkRequestBuilder add(byte[] data2, int from2, int length, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        ((BulkRequest)this.request).add(data2, from2, length, contentUnsafe, defaultIndex, defaultType);
        return this;
    }

    public BulkRequestBuilder setReplicationType(ReplicationType replicationType) {
        ((BulkRequest)this.request).replicationType(replicationType);
        return this;
    }

    public BulkRequestBuilder setConsistencyLevel(WriteConsistencyLevel consistencyLevel) {
        ((BulkRequest)this.request).consistencyLevel(consistencyLevel);
        return this;
    }

    public BulkRequestBuilder setRefresh(boolean refresh) {
        ((BulkRequest)this.request).refresh(refresh);
        return this;
    }

    public final BulkRequestBuilder setTimeout(TimeValue timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public final BulkRequestBuilder setTimeout(String timeout) {
        ((BulkRequest)this.request).timeout(timeout);
        return this;
    }

    public int numberOfActions() {
        return ((BulkRequest)this.request).numberOfActions();
    }

    @Override
    protected void doExecute(ActionListener<BulkResponse> listener) {
        ((Client)((Object)this.client)).bulk((BulkRequest)this.request, listener);
    }
}

