/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.warmer.delete;

import java.util.ArrayList;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.warmer.IndexWarmerMissingException;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteWarmerAction
extends TransportMasterNodeOperationAction<DeleteWarmerRequest, DeleteWarmerResponse> {
    @Inject
    public TransportDeleteWarmerAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/warmer/delete";
    }

    @Override
    protected DeleteWarmerRequest newRequest() {
        return new DeleteWarmerRequest();
    }

    @Override
    protected DeleteWarmerResponse newResponse() {
        return new DeleteWarmerResponse();
    }

    @Override
    protected void doExecute(DeleteWarmerRequest request, ActionListener<DeleteWarmerResponse> listener) {
        request.indices(this.clusterService.state().metaData().concreteIndices(request.indices()));
        super.doExecute(request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(DeleteWarmerRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA, request.indices());
    }

    @Override
    protected void masterOperation(final DeleteWarmerRequest request, ClusterState state, final ActionListener<DeleteWarmerResponse> listener) throws ElasticSearchException {
        this.clusterService.submitStateUpdateTask("delete_warmer [" + request.name() + "]", new AckedClusterStateUpdateTask(){

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Throwable t) {
                listener.onResponse(new DeleteWarmerResponse(true));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new DeleteWarmerResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.timeout();
            }

            @Override
            public TimeValue timeout() {
                return request.masterNodeTimeout();
            }

            @Override
            public void onFailure(String source, Throwable t) {
                TransportDeleteWarmerAction.this.logger.debug("failed to delete warmer [{}] on indices [{}]", t, request.name(), request.indices());
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                IndexWarmersMetaData warmers;
                IndexMetaData indexMetaData;
                MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
                boolean globalFoundAtLeastOne = false;
                for (String index : request.indices()) {
                    indexMetaData = currentState.metaData().index(index);
                    if (indexMetaData == null) {
                        throw new IndexMissingException(new Index(index));
                    }
                    warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                    if (warmers == null) continue;
                    ArrayList<IndexWarmersMetaData.Entry> entries = Lists.newArrayList();
                    for (IndexWarmersMetaData.Entry entry2 : warmers.entries()) {
                        if (request.name() == null || Regex.simpleMatch(request.name(), entry2.name())) {
                            globalFoundAtLeastOne = true;
                            continue;
                        }
                        entries.add(entry2);
                    }
                    if (entries.size() == warmers.entries().size()) continue;
                    warmers = new IndexWarmersMetaData(entries.toArray(new IndexWarmersMetaData.Entry[entries.size()]));
                    IndexMetaData.Builder indexBuilder = IndexMetaData.builder(indexMetaData).putCustom("warmers", warmers);
                    mdBuilder.put(indexBuilder);
                }
                if (!globalFoundAtLeastOne) {
                    if (request.name() == null) {
                        return currentState;
                    }
                    throw new IndexWarmerMissingException(request.name());
                }
                if (TransportDeleteWarmerAction.this.logger.isInfoEnabled()) {
                    for (String index : request.indices()) {
                        indexMetaData = currentState.metaData().index(index);
                        if (indexMetaData == null) {
                            throw new IndexMissingException(new Index(index));
                        }
                        warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                        if (warmers == null) continue;
                        for (IndexWarmersMetaData.Entry entry3 : warmers.entries()) {
                            if (!Regex.simpleMatch(request.name(), entry3.name())) continue;
                            TransportDeleteWarmerAction.this.logger.info("[{}] delete warmer [{}]", index, entry3.name());
                        }
                    }
                }
                return ClusterState.builder(currentState).metaData(mdBuilder).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }
}

