/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.support.broadcast.BroadcastOperationResponse;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class ValidateQueryResponse
extends BroadcastOperationResponse {
    private boolean valid;
    private List<QueryExplanation> queryExplanations;

    ValidateQueryResponse() {
    }

    ValidateQueryResponse(boolean valid, List<QueryExplanation> queryExplanations, int totalShards, int successfulShards, int failedShards, List<ShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.valid = valid;
        this.queryExplanations = queryExplanations;
        if (queryExplanations == null) {
            this.queryExplanations = ImmutableList.of();
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<? extends QueryExplanation> getQueryExplanation() {
        if (this.queryExplanations == null) {
            return ImmutableList.of();
        }
        return this.queryExplanations;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.valid = in.readBoolean();
        int size2 = in.readVInt();
        if (size2 > 0) {
            this.queryExplanations = new ArrayList<QueryExplanation>(size2);
            for (int i = 0; i < size2; ++i) {
                this.queryExplanations.add(QueryExplanation.readQueryExplanation(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.valid);
        out.writeVInt(this.queryExplanations.size());
        for (QueryExplanation exp : this.queryExplanations) {
            exp.writeTo(out);
        }
    }
}

