/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaDataIndexTemplateService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutIndexTemplateAction
extends TransportMasterNodeOperationAction<PutIndexTemplateRequest, PutIndexTemplateResponse> {
    private final MetaDataIndexTemplateService indexTemplateService;

    @Inject
    public TransportPutIndexTemplateAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexTemplateService indexTemplateService) {
        super(settings, transportService, clusterService, threadPool);
        this.indexTemplateService = indexTemplateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/template/put";
    }

    @Override
    protected PutIndexTemplateRequest newRequest() {
        return new PutIndexTemplateRequest();
    }

    @Override
    protected PutIndexTemplateResponse newResponse() {
        return new PutIndexTemplateResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutIndexTemplateRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, "");
    }

    @Override
    protected void masterOperation(final PutIndexTemplateRequest request, ClusterState state, final ActionListener<PutIndexTemplateResponse> listener) throws ElasticSearchException {
        String cause = request.cause();
        if (cause.length() == 0) {
            cause = "api";
        }
        this.indexTemplateService.putTemplate(new MetaDataIndexTemplateService.PutRequest(cause, request.name()).template(request.template()).order(request.order()).settings(request.settings()).mappings(request.mappings()).customs(request.customs()).create(request.create()).masterTimeout(request.masterNodeTimeout()), new MetaDataIndexTemplateService.PutListener(){

            @Override
            public void onResponse(MetaDataIndexTemplateService.PutResponse response) {
                listener.onResponse(new PutIndexTemplateResponse(response.acknowledged()));
            }

            @Override
            public void onFailure(Throwable t) {
                TransportPutIndexTemplateAction.this.logger.debug("failed to delete template [{}]", t, request.name());
                listener.onFailure(t);
            }
        });
    }
}

