/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.put;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class PutIndexTemplateRequest
extends MasterNodeOperationRequest<PutIndexTemplateRequest> {
    private String name;
    private String cause = "";
    private String template;
    private int order;
    private boolean create;
    private Settings settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
    private Map<String, String> mappings = Maps.newHashMap();
    private Map<String, IndexMetaData.Custom> customs = Maps.newHashMap();

    PutIndexTemplateRequest() {
    }

    public PutIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.template == null) {
            validationException = ValidateActions.addValidationError("template is missing", validationException);
        }
        return validationException;
    }

    public PutIndexTemplateRequest name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public PutIndexTemplateRequest template(String template) {
        this.template = template;
        return this;
    }

    public String template() {
        return this.template;
    }

    public PutIndexTemplateRequest order(int order) {
        this.order = order;
        return this;
    }

    public int order() {
        return this.order;
    }

    public PutIndexTemplateRequest create(boolean create2) {
        this.create = create2;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public PutIndexTemplateRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public PutIndexTemplateRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public PutIndexTemplateRequest settings(String source) {
        this.settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        return this;
    }

    public PutIndexTemplateRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    Settings settings() {
        return this.settings;
    }

    public PutIndexTemplateRequest mapping(String type, String source) {
        this.mappings.put(type, source);
        return this;
    }

    public PutIndexTemplateRequest cause(String cause) {
        this.cause = cause;
        return this;
    }

    public String cause() {
        return this.cause;
    }

    public PutIndexTemplateRequest mapping(String type, XContentBuilder source) {
        try {
            this.mappings.put(type, source.string());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for mapping request", e);
        }
        return this;
    }

    public PutIndexTemplateRequest mapping(String type, Map<String, Object> source) {
        if (source.size() != 1 || !source.containsKey(type)) {
            source = MapBuilder.newMapBuilder().put(type, source).map();
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            return this.mapping(type, builder.string());
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    Map<String, String> mappings() {
        return this.mappings;
    }

    public PutIndexTemplateRequest source(XContentBuilder templateBuilder) {
        try {
            return this.source(templateBuilder.bytes());
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("Failed to build json for template request", e);
        }
    }

    public PutIndexTemplateRequest source(Map templateSource) {
        Map source = templateSource;
        for (Map.Entry entry2 : source.entrySet()) {
            String name = (String)entry2.getKey();
            if (name.equals("template")) {
                this.template(entry2.getValue().toString());
                continue;
            }
            if (name.equals("order")) {
                this.order(XContentMapValues.nodeIntegerValue(entry2.getValue(), this.order()));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry2.getValue() instanceof Map)) {
                    throw new ElasticSearchIllegalArgumentException("Malformed settings section, should include an inner object");
                }
                this.settings((Map)entry2.getValue());
                continue;
            }
            if (name.equals("mappings")) {
                Map mappings = (Map)entry2.getValue();
                for (Map.Entry entry1 : mappings.entrySet()) {
                    if (!(entry1.getValue() instanceof Map)) {
                        throw new ElasticSearchIllegalArgumentException("Malformed mappings section for type [" + (String)entry1.getKey() + "], should include an inner object describing the mapping");
                    }
                    this.mapping((String)entry1.getKey(), (Map)entry1.getValue());
                }
                continue;
            }
            IndexMetaData.Custom.Factory factory = IndexMetaData.lookupFactory(name);
            if (factory == null) continue;
            try {
                this.customs.put(name, (IndexMetaData.Custom)factory.fromMap((Map)entry2.getValue()));
            }
            catch (IOException e) {
                throw new ElasticSearchParseException("failed to parse custom metadata for [" + name + "]");
            }
        }
        return this;
    }

    public PutIndexTemplateRequest source(String templateSource) {
        try {
            return this.source(XContentFactory.xContent(templateSource).createParser(templateSource).mapOrderedAndClose());
        }
        catch (Exception e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source [" + templateSource + "]", e);
        }
    }

    public PutIndexTemplateRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public PutIndexTemplateRequest source(byte[] source, int offset, int length) {
        try {
            return this.source(XContentFactory.xContent(source, offset, length).createParser(source, offset, length).mapOrderedAndClose());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source", e);
        }
    }

    public PutIndexTemplateRequest source(BytesReference source) {
        try {
            return this.source(XContentFactory.xContent(source).createParser(source).mapOrderedAndClose());
        }
        catch (IOException e) {
            throw new ElasticSearchIllegalArgumentException("failed to parse template source", e);
        }
    }

    public PutIndexTemplateRequest custom(IndexMetaData.Custom custom) {
        this.customs.put(custom.type(), custom);
        return this;
    }

    Map<String, IndexMetaData.Custom> customs() {
        return this.customs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.cause = in.readString();
        this.name = in.readString();
        this.template = in.readString();
        this.order = in.readInt();
        this.create = in.readBoolean();
        this.settings = ImmutableSettings.readSettingsFromStream(in);
        if (in.getVersion().onOrBefore(Version.V_0_90_7)) {
            TimeValue.readTimeValue(in);
        }
        int size2 = in.readVInt();
        for (int i = 0; i < size2; ++i) {
            this.mappings.put(in.readString(), in.readString());
        }
        int customSize = in.readVInt();
        for (int i = 0; i < customSize; ++i) {
            String type = in.readString();
            Object customIndexMetaData = IndexMetaData.lookupFactorySafe(type).readFrom(in);
            this.customs.put(type, (IndexMetaData.Custom)customIndexMetaData);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.cause);
        out.writeString(this.name);
        out.writeString(this.template);
        out.writeInt(this.order);
        out.writeBoolean(this.create);
        ImmutableSettings.writeSettingsToStream(this.settings, out);
        if (out.getVersion().onOrBefore(Version.V_0_90_7)) {
            AcknowledgedRequest.DEFAULT_ACK_TIMEOUT.writeTo(out);
        }
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, String> entry2 : this.mappings.entrySet()) {
            out.writeString(entry2.getKey());
            out.writeString(entry2.getValue());
        }
        out.writeVInt(this.customs.size());
        for (Map.Entry<String, Object> entry3 : this.customs.entrySet()) {
            out.writeString(entry3.getKey());
            IndexMetaData.lookupFactorySafe(entry3.getKey()).writeTo((IndexMetaData.Custom)entry3.getValue(), out);
        }
    }
}

