/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.get;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetIndexTemplatesRequest
extends MasterNodeOperationRequest<GetIndexTemplatesRequest> {
    private String[] names;

    public GetIndexTemplatesRequest() {
    }

    @Deprecated
    public GetIndexTemplatesRequest(String name) {
        this.names = new String[1];
        this.names[0] = name;
    }

    public GetIndexTemplatesRequest(String ... names) {
        this.names = names;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.names == null) {
            validationException = ValidateActions.addValidationError("names is null or empty", validationException);
        } else {
            for (String name : this.names) {
                if (name != null && Strings.hasText(name)) continue;
                validationException = ValidateActions.addValidationError("name is missing", validationException);
            }
        }
        return validationException;
    }

    @Deprecated
    public GetIndexTemplatesRequest name(String name) {
        this.names = new String[1];
        this.names[0] = name;
        return this;
    }

    @Deprecated
    public String name() {
        if (this.names != null && this.names.length > 0) {
            return this.names[0];
        }
        return null;
    }

    public GetIndexTemplatesRequest names(String ... names) {
        this.names = names;
        return this;
    }

    public String[] names() {
        return this.names;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().onOrAfter(Version.V_0_90_4)) {
            this.names = in.readStringArray();
        } else {
            this.names = new String[1];
            this.names[0] = in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_0_90_4)) {
            out.writeStringArray(this.names);
        } else {
            out.writeString(this.names.length == 0 ? "*" : this.names[0]);
        }
    }
}

