/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.delete;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.MasterNodeOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;

public class DeleteIndexTemplateRequest
extends MasterNodeOperationRequest<DeleteIndexTemplateRequest> {
    private String name;

    DeleteIndexTemplateRequest() {
    }

    public DeleteIndexTemplateRequest(String name) {
        this.name = name;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        return validationException;
    }

    String name() {
        return this.name;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.name = in.readString();
        if (in.getVersion().onOrBefore(Version.V_0_90_7)) {
            TimeValue.readTimeValue(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        if (out.getVersion().onOrBefore(Version.V_0_90_7)) {
            AcknowledgedRequest.DEFAULT_ACK_TIMEOUT.writeTo(out);
        }
    }
}

