/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.GatewayRecoveryStatus;
import org.elasticsearch.action.admin.indices.status.GatewaySnapshotStatus;
import org.elasticsearch.action.admin.indices.status.PeerRecoveryStatus;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.shard.IndexShardState;

public class ShardStatus
extends BroadcastShardOperationResponse {
    private ShardRouting shardRouting;
    IndexShardState state;
    ByteSizeValue storeSize;
    long translogId = -1L;
    long translogOperations = -1L;
    DocsStatus docs;
    MergeStats mergeStats;
    RefreshStats refreshStats;
    FlushStats flushStats;
    PeerRecoveryStatus peerRecoveryStatus;
    GatewayRecoveryStatus gatewayRecoveryStatus;
    GatewaySnapshotStatus gatewaySnapshotStatus;

    ShardStatus() {
    }

    ShardStatus(ShardRouting shardRouting) {
        super(shardRouting.index(), shardRouting.id());
        this.shardRouting = shardRouting;
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public IndexShardState getState() {
        return this.state;
    }

    public ByteSizeValue getStoreSize() {
        return this.storeSize;
    }

    public long getTranslogId() {
        return this.translogId;
    }

    public long getTranslogOperations() {
        return this.translogOperations;
    }

    public DocsStatus getDocs() {
        return this.docs;
    }

    public MergeStats getMergeStats() {
        return this.mergeStats;
    }

    public RefreshStats getRefreshStats() {
        return this.refreshStats;
    }

    public FlushStats getFlushStats() {
        return this.flushStats;
    }

    public PeerRecoveryStatus getPeerRecoveryStatus() {
        return this.peerRecoveryStatus;
    }

    public GatewayRecoveryStatus getGatewayRecoveryStatus() {
        return this.gatewayRecoveryStatus;
    }

    public GatewaySnapshotStatus getGatewaySnapshotStatus() {
        return this.gatewaySnapshotStatus;
    }

    public static ShardStatus readIndexShardStatus(StreamInput in) throws IOException {
        ShardStatus shardStatus = new ShardStatus();
        shardStatus.readFrom(in);
        return shardStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        out.writeByte(this.state.id());
        if (this.storeSize == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.storeSize.writeTo(out);
        }
        out.writeLong(this.translogId);
        out.writeLong(this.translogOperations);
        if (this.docs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.docs.getNumDocs());
            out.writeLong(this.docs.getMaxDoc());
            out.writeLong(this.docs.getDeletedDocs());
        }
        if (this.peerRecoveryStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.peerRecoveryStatus.stage.value());
            out.writeVLong(this.peerRecoveryStatus.startTime);
            out.writeVLong(this.peerRecoveryStatus.time);
            out.writeVLong(this.peerRecoveryStatus.indexSize);
            out.writeVLong(this.peerRecoveryStatus.reusedIndexSize);
            out.writeVLong(this.peerRecoveryStatus.recoveredIndexSize);
            out.writeVLong(this.peerRecoveryStatus.recoveredTranslogOperations);
        }
        if (this.gatewayRecoveryStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.gatewayRecoveryStatus.stage.value());
            out.writeVLong(this.gatewayRecoveryStatus.startTime);
            out.writeVLong(this.gatewayRecoveryStatus.time);
            out.writeVLong(this.gatewayRecoveryStatus.indexSize);
            out.writeVLong(this.gatewayRecoveryStatus.reusedIndexSize);
            out.writeVLong(this.gatewayRecoveryStatus.recoveredIndexSize);
            out.writeVLong(this.gatewayRecoveryStatus.recoveredTranslogOperations);
        }
        if (this.gatewaySnapshotStatus == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeByte(this.gatewaySnapshotStatus.stage.value());
            out.writeVLong(this.gatewaySnapshotStatus.startTime);
            out.writeVLong(this.gatewaySnapshotStatus.time);
            out.writeVLong(this.gatewaySnapshotStatus.indexSize);
            out.writeVInt(this.gatewaySnapshotStatus.getExpectedNumberOfOperations());
        }
        if (this.mergeStats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mergeStats.writeTo(out);
        }
        if (this.refreshStats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.refreshStats.writeTo(out);
        }
        if (this.flushStats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.flushStats.writeTo(out);
        }
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
        this.state = IndexShardState.fromId(in.readByte());
        if (in.readBoolean()) {
            this.storeSize = ByteSizeValue.readBytesSizeValue(in);
        }
        this.translogId = in.readLong();
        this.translogOperations = in.readLong();
        if (in.readBoolean()) {
            this.docs = new DocsStatus();
            this.docs.numDocs = in.readLong();
            this.docs.maxDoc = in.readLong();
            this.docs.deletedDocs = in.readLong();
        }
        if (in.readBoolean()) {
            this.peerRecoveryStatus = new PeerRecoveryStatus(PeerRecoveryStatus.Stage.fromValue(in.readByte()), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }
        if (in.readBoolean()) {
            this.gatewayRecoveryStatus = new GatewayRecoveryStatus(GatewayRecoveryStatus.Stage.fromValue(in.readByte()), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong(), in.readVLong());
        }
        if (in.readBoolean()) {
            this.gatewaySnapshotStatus = new GatewaySnapshotStatus(GatewaySnapshotStatus.Stage.fromValue(in.readByte()), in.readVLong(), in.readVLong(), in.readVLong(), in.readVInt());
        }
        if (in.readBoolean()) {
            this.mergeStats = MergeStats.readMergeStats(in);
        }
        if (in.readBoolean()) {
            this.refreshStats = RefreshStats.readRefreshStats(in);
        }
        if (in.readBoolean()) {
            this.flushStats = FlushStats.readFlushStats(in);
        }
    }
}

