/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.segments;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.segments.IndexShardSegments;
import org.elasticsearch.action.admin.indices.segments.ShardSegments;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;

public class IndexSegments
implements Iterable<IndexShardSegments> {
    private final String index;
    private final Map<Integer, IndexShardSegments> indexShards;

    IndexSegments(String index, ShardSegments[] shards) {
        this.index = index;
        HashMap tmpIndexShards = Maps.newHashMap();
        for (ShardSegments shard : shards) {
            ArrayList<ShardSegments> lst = (ArrayList<ShardSegments>)tmpIndexShards.get(shard.getShardRouting().id());
            if (lst == null) {
                lst = Lists.newArrayList();
                tmpIndexShards.put(shard.getShardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = Maps.newHashMap();
        for (Map.Entry entry2 : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry2.getKey(), new IndexShardSegments(((ShardSegments)((List)entry2.getValue()).get(0)).getShardRouting().shardId(), ((List)entry2.getValue()).toArray(new ShardSegments[((List)entry2.getValue()).size()])));
        }
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, IndexShardSegments> getShards() {
        return this.indexShards;
    }

    @Override
    public Iterator<IndexShardSegments> iterator() {
        return this.indexShards.values().iterator();
    }
}

