/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.open;

import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.open.OpenIndexClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateListener;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportOpenIndexAction
extends TransportMasterNodeOperationAction<OpenIndexRequest, OpenIndexResponse> {
    private final MetaDataIndexStateService indexStateService;

    @Inject
    public TransportOpenIndexAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexStateService indexStateService) {
        super(settings, transportService, clusterService, threadPool);
        this.indexStateService = indexStateService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "indices/open";
    }

    @Override
    protected OpenIndexRequest newRequest() {
        return new OpenIndexRequest();
    }

    @Override
    protected OpenIndexResponse newResponse() {
        return new OpenIndexResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(OpenIndexRequest request, ClusterState state) {
        request.index(this.clusterService.state().metaData().concreteIndex(request.index()));
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, request.index());
    }

    @Override
    protected void masterOperation(final OpenIndexRequest request, ClusterState state, final ActionListener<OpenIndexResponse> listener) throws ElasticSearchException {
        OpenIndexClusterStateUpdateRequest updateRequest = ((OpenIndexClusterStateUpdateRequest)((OpenIndexClusterStateUpdateRequest)new OpenIndexClusterStateUpdateRequest().ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout())).index(request.index());
        this.indexStateService.openIndex(updateRequest, new ClusterStateUpdateListener(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new OpenIndexResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Throwable t) {
                TransportOpenIndexAction.this.logger.debug("failed to open indices [{}]", t, request.index());
                listener.onFailure(t);
            }
        });
    }
}

